/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotificationRuleResponse extends CodestarNotificationsResponse implements
        ToCopyableBuilder<DescribeNotificationRuleResponse.Builder, DescribeNotificationRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeNotificationRuleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeNotificationRuleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<EventTypeSummary>> EVENT_TYPES_FIELD = SdkField
            .<List<EventTypeSummary>> builder(MarshallingType.LIST)
            .memberName("EventTypes")
            .getter(getter(DescribeNotificationRuleResponse::eventTypes))
            .setter(setter(Builder::eventTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(DescribeNotificationRuleResponse::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<TargetSummary>> TARGETS_FIELD = SdkField
            .<List<TargetSummary>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(DescribeNotificationRuleResponse::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailType").getter(getter(DescribeNotificationRuleResponse::detailTypeAsString))
            .setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeNotificationRuleResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeNotificationRuleResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DescribeNotificationRuleResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimestamp").getter(getter(DescribeNotificationRuleResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeNotificationRuleResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            EVENT_TYPES_FIELD, RESOURCE_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD, CREATED_BY_FIELD, STATUS_FIELD,
            CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final List<EventTypeSummary> eventTypes;

    private final String resource;

    private final List<TargetSummary> targets;

    private final String detailType;

    private final String createdBy;

    private final String status;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private final Map<String, String> tags;

    private DescribeNotificationRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.eventTypes = builder.eventTypes;
        this.resource = builder.resource;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
        this.createdBy = builder.createdBy;
        this.status = builder.status;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification rule.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the notification rule.
     * </p>
     * 
     * @return The name of the notification rule.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventTypes() {
        return eventTypes != null && !(eventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the event types associated with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypes} method.
     * </p>
     * 
     * @return A list of the event types associated with the notification rule.
     */
    public final List<EventTypeSummary> eventTypes() {
        return eventTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource associated with the notification rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource associated with the notification rule.
     */
    public final String resource() {
        return resource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Chatbot topics and Chatbot clients associated with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return A list of the Chatbot topics and Chatbot clients associated with the notification rule.
     */
    public final List<TargetSummary> targets() {
        return targets;
    }

    /**
     * <p>
     * The level of detail included in the notifications for this resource. BASIC will include only the contents of the
     * event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided by AWS
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail included in the notifications for this resource. BASIC will include only the contents
     *         of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information
     *         provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is
     *         created.
     * @see DetailType
     */
    public final DetailType detailType() {
        return DetailType.fromValue(detailType);
    }

    /**
     * <p>
     * The level of detail included in the notifications for this resource. BASIC will include only the contents of the
     * event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided by AWS
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail included in the notifications for this resource. BASIC will include only the contents
     *         of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information
     *         provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is
     *         created.
     * @see DetailType
     */
    public final String detailTypeAsString() {
        return detailType;
    }

    /**
     * <p>
     * The name or email alias of the person who created the notification rule.
     * </p>
     * 
     * @return The name or email alias of the person who created the notification rule.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     * notifications).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     *         notifications).
     * @see NotificationRuleStatus
     */
    public final NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     * notifications).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
     *         notifications).
     * @see NotificationRuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the notification rule was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the notification rule was created, in timestamp format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The date and time the notification rule was most recently updated, in timestamp format.
     * </p>
     * 
     * @return The date and time the notification rule was most recently updated, in timestamp format.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the notification rule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypes() ? eventTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationRuleResponse)) {
            return false;
        }
        DescribeNotificationRuleResponse other = (DescribeNotificationRuleResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && hasEventTypes() == other.hasEventTypes() && Objects.equals(eventTypes(), other.eventTypes())
                && Objects.equals(resource(), other.resource()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && Objects.equals(detailTypeAsString(), other.detailTypeAsString())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNotificationRuleResponse").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventTypes", hasEventTypes() ? eventTypes() : null).add("Resource", resource())
                .add("Targets", hasTargets() ? targets() : null).add("DetailType", detailTypeAsString())
                .add("CreatedBy", createdBy()).add("Status", statusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EventTypes":
            return Optional.ofNullable(clazz.cast(eventTypes()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailTypeAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EventTypes", EVENT_TYPES_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("DetailType", DETAIL_TYPE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationRuleResponse, T> g) {
        return obj -> g.apply((DescribeNotificationRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotificationRuleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification rule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the notification rule.
         * </p>
         * 
         * @param name
         *        The name of the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of the event types associated with the notification rule.
         * </p>
         * 
         * @param eventTypes
         *        A list of the event types associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(Collection<EventTypeSummary> eventTypes);

        /**
         * <p>
         * A list of the event types associated with the notification rule.
         * </p>
         * 
         * @param eventTypes
         *        A list of the event types associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(EventTypeSummary... eventTypes);

        /**
         * <p>
         * A list of the event types associated with the notification rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #eventTypes(List<EventTypeSummary>)}.
         * 
         * @param eventTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTypes(java.util.Collection<EventTypeSummary>)
         */
        Builder eventTypes(Consumer<EventTypeSummary.Builder>... eventTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource associated with the notification rule.
         * </p>
         * 
         * @param resource
         *        The Amazon Resource Name (ARN) of the resource associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * A list of the Chatbot topics and Chatbot clients associated with the notification rule.
         * </p>
         * 
         * @param targets
         *        A list of the Chatbot topics and Chatbot clients associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<TargetSummary> targets);

        /**
         * <p>
         * A list of the Chatbot topics and Chatbot clients associated with the notification rule.
         * </p>
         * 
         * @param targets
         *        A list of the Chatbot topics and Chatbot clients associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(TargetSummary... targets);

        /**
         * <p>
         * A list of the Chatbot topics and Chatbot clients associated with the notification rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestarnotifications.model.TargetSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.codestarnotifications.model.TargetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestarnotifications.model.TargetSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #targets(List<TargetSummary>)}.
         * 
         * @param targets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestarnotifications.model.TargetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(java.util.Collection<TargetSummary>)
         */
        Builder targets(Consumer<TargetSummary.Builder>... targets);

        /**
         * <p>
         * The level of detail included in the notifications for this resource. BASIC will include only the contents of
         * the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided by
         * AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail included in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental
         *        information provided by AWS CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * The level of detail included in the notifications for this resource. BASIC will include only the contents of
         * the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided by
         * AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail included in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental
         *        information provided by AWS CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(DetailType detailType);

        /**
         * <p>
         * The name or email alias of the person who created the notification rule.
         * </p>
         * 
         * @param createdBy
         *        The name or email alias of the person who created the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         * notifications).
         * </p>
         * 
         * @param status
         *        The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         *        notifications).
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         * notifications).
         * </p>
         * 
         * @param status
         *        The status of the notification rule. Valid statuses are on (sending notifications) or off (not sending
         *        notifications).
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(NotificationRuleStatus status);

        /**
         * <p>
         * The date and time the notification rule was created, in timestamp format.
         * </p>
         * 
         * @param createdTimestamp
         *        The date and time the notification rule was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The date and time the notification rule was most recently updated, in timestamp format.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The date and time the notification rule was most recently updated, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The tags associated with the notification rule.
         * </p>
         * 
         * @param tags
         *        The tags associated with the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CodestarNotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private List<EventTypeSummary> eventTypes = DefaultSdkAutoConstructList.getInstance();

        private String resource;

        private List<TargetSummary> targets = DefaultSdkAutoConstructList.getInstance();

        private String detailType;

        private String createdBy;

        private String status;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationRuleResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            eventTypes(model.eventTypes);
            resource(model.resource);
            targets(model.targets);
            detailType(model.detailType);
            createdBy(model.createdBy);
            status(model.status);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<EventTypeSummary.Builder> getEventTypes() {
            List<EventTypeSummary.Builder> result = EventTypeBatchCopier.copyToBuilder(this.eventTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTypes(Collection<EventTypeSummary.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copyFromBuilder(eventTypes);
        }

        @Override
        public final Builder eventTypes(Collection<EventTypeSummary> eventTypes) {
            this.eventTypes = EventTypeBatchCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventTypeSummary... eventTypes) {
            eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventTypeSummary.Builder>... eventTypes) {
            eventTypes(Stream.of(eventTypes).map(c -> EventTypeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final List<TargetSummary.Builder> getTargets() {
            List<TargetSummary.Builder> result = TargetsBatchCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<TargetSummary.BuilderImpl> targets) {
            this.targets = TargetsBatchCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<TargetSummary> targets) {
            this.targets = TargetsBatchCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(TargetSummary... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<TargetSummary.Builder>... targets) {
            targets(Stream.of(targets).map(c -> TargetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetailType() {
            return detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeNotificationRuleResponse build() {
            return new DescribeNotificationRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
