/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFilter;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationRulesRequest
extends CodestarNotificationsRequest
implements ToCopyableBuilder<Builder, ListNotificationRulesRequest> {
    private static final SdkField<List<ListNotificationRulesFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListNotificationRulesRequest.getter(ListNotificationRulesRequest::filters)).setter(ListNotificationRulesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListNotificationRulesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotificationRulesRequest.getter(ListNotificationRulesRequest::nextToken)).setter(ListNotificationRulesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListNotificationRulesRequest.getter(ListNotificationRulesRequest::maxResults)).setter(ListNotificationRulesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<ListNotificationRulesFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private ListNotificationRulesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<ListNotificationRulesFilter> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationRulesRequest)) {
            return false;
        }
        ListNotificationRulesRequest other = (ListNotificationRulesRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListNotificationRulesRequest").add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationRulesRequest, T> g) {
        return obj -> g.apply((ListNotificationRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodestarNotificationsRequest.BuilderImpl
    implements Builder {
        private List<ListNotificationRulesFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationRulesRequest model) {
            super(model);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<ListNotificationRulesFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ListNotificationRulesFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ListNotificationRulesFilter> filters) {
            this.filters = ListNotificationRulesFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListNotificationRulesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListNotificationRulesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ListNotificationRulesFilter)((ListNotificationRulesFilter.Builder)ListNotificationRulesFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ListNotificationRulesFilter.BuilderImpl> filters) {
            this.filters = ListNotificationRulesFiltersCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotificationRulesRequest build() {
            return new ListNotificationRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodestarNotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationRulesRequest> {
        public Builder filters(Collection<ListNotificationRulesFilter> var1);

        public Builder filters(ListNotificationRulesFilter ... var1);

        public Builder filters(Consumer<ListNotificationRulesFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

