/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of findings metrics for an account on a specified date.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountFindingsMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountFindingsMetric.Builder, AccountFindingsMetric> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("date")
            .getter(getter(AccountFindingsMetric::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final SdkField<FindingMetricsValuePerSeverity> NEW_FINDINGS_FIELD = SdkField
            .<FindingMetricsValuePerSeverity> builder(MarshallingType.SDK_POJO).memberName("newFindings")
            .getter(getter(AccountFindingsMetric::newFindings)).setter(setter(Builder::newFindings))
            .constructor(FindingMetricsValuePerSeverity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newFindings").build()).build();

    private static final SdkField<FindingMetricsValuePerSeverity> CLOSED_FINDINGS_FIELD = SdkField
            .<FindingMetricsValuePerSeverity> builder(MarshallingType.SDK_POJO).memberName("closedFindings")
            .getter(getter(AccountFindingsMetric::closedFindings)).setter(setter(Builder::closedFindings))
            .constructor(FindingMetricsValuePerSeverity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closedFindings").build()).build();

    private static final SdkField<FindingMetricsValuePerSeverity> OPEN_FINDINGS_FIELD = SdkField
            .<FindingMetricsValuePerSeverity> builder(MarshallingType.SDK_POJO).memberName("openFindings")
            .getter(getter(AccountFindingsMetric::openFindings)).setter(setter(Builder::openFindings))
            .constructor(FindingMetricsValuePerSeverity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openFindings").build()).build();

    private static final SdkField<FindingMetricsValuePerSeverity> MEAN_TIME_TO_CLOSE_FIELD = SdkField
            .<FindingMetricsValuePerSeverity> builder(MarshallingType.SDK_POJO).memberName("meanTimeToClose")
            .getter(getter(AccountFindingsMetric::meanTimeToClose)).setter(setter(Builder::meanTimeToClose))
            .constructor(FindingMetricsValuePerSeverity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meanTimeToClose").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD,
            NEW_FINDINGS_FIELD, CLOSED_FINDINGS_FIELD, OPEN_FINDINGS_FIELD, MEAN_TIME_TO_CLOSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant date;

    private final FindingMetricsValuePerSeverity newFindings;

    private final FindingMetricsValuePerSeverity closedFindings;

    private final FindingMetricsValuePerSeverity openFindings;

    private final FindingMetricsValuePerSeverity meanTimeToClose;

    private AccountFindingsMetric(BuilderImpl builder) {
        this.date = builder.date;
        this.newFindings = builder.newFindings;
        this.closedFindings = builder.closedFindings;
        this.openFindings = builder.openFindings;
        this.meanTimeToClose = builder.meanTimeToClose;
    }

    /**
     * <p>
     * The date from which the findings metrics were retrieved.
     * </p>
     * 
     * @return The date from which the findings metrics were retrieved.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The number of new findings of each severity on the specified date.
     * </p>
     * 
     * @return The number of new findings of each severity on the specified date.
     */
    public final FindingMetricsValuePerSeverity newFindings() {
        return newFindings;
    }

    /**
     * <p>
     * The number of closed findings of each severity on the specified date.
     * </p>
     * 
     * @return The number of closed findings of each severity on the specified date.
     */
    public final FindingMetricsValuePerSeverity closedFindings() {
        return closedFindings;
    }

    /**
     * <p>
     * The number of open findings of each severity as of the specified date.
     * </p>
     * 
     * @return The number of open findings of each severity as of the specified date.
     */
    public final FindingMetricsValuePerSeverity openFindings() {
        return openFindings;
    }

    /**
     * <p>
     * The average time in days it takes to close findings of each severity as of a specified date.
     * </p>
     * 
     * @return The average time in days it takes to close findings of each severity as of a specified date.
     */
    public final FindingMetricsValuePerSeverity meanTimeToClose() {
        return meanTimeToClose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(newFindings());
        hashCode = 31 * hashCode + Objects.hashCode(closedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(openFindings());
        hashCode = 31 * hashCode + Objects.hashCode(meanTimeToClose());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountFindingsMetric)) {
            return false;
        }
        AccountFindingsMetric other = (AccountFindingsMetric) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(newFindings(), other.newFindings())
                && Objects.equals(closedFindings(), other.closedFindings())
                && Objects.equals(openFindings(), other.openFindings())
                && Objects.equals(meanTimeToClose(), other.meanTimeToClose());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountFindingsMetric").add("Date", date()).add("NewFindings", newFindings())
                .add("ClosedFindings", closedFindings()).add("OpenFindings", openFindings())
                .add("MeanTimeToClose", meanTimeToClose()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        case "newFindings":
            return Optional.ofNullable(clazz.cast(newFindings()));
        case "closedFindings":
            return Optional.ofNullable(clazz.cast(closedFindings()));
        case "openFindings":
            return Optional.ofNullable(clazz.cast(openFindings()));
        case "meanTimeToClose":
            return Optional.ofNullable(clazz.cast(meanTimeToClose()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("date", DATE_FIELD);
        map.put("newFindings", NEW_FINDINGS_FIELD);
        map.put("closedFindings", CLOSED_FINDINGS_FIELD);
        map.put("openFindings", OPEN_FINDINGS_FIELD);
        map.put("meanTimeToClose", MEAN_TIME_TO_CLOSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountFindingsMetric, T> g) {
        return obj -> g.apply((AccountFindingsMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountFindingsMetric> {
        /**
         * <p>
         * The date from which the findings metrics were retrieved.
         * </p>
         * 
         * @param date
         *        The date from which the findings metrics were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The number of new findings of each severity on the specified date.
         * </p>
         * 
         * @param newFindings
         *        The number of new findings of each severity on the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newFindings(FindingMetricsValuePerSeverity newFindings);

        /**
         * <p>
         * The number of new findings of each severity on the specified date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingMetricsValuePerSeverity.Builder}
         * avoiding the need to create one manually via {@link FindingMetricsValuePerSeverity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingMetricsValuePerSeverity.Builder#build()} is called
         * immediately and its result is passed to {@link #newFindings(FindingMetricsValuePerSeverity)}.
         * 
         * @param newFindings
         *        a consumer that will call methods on {@link FindingMetricsValuePerSeverity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newFindings(FindingMetricsValuePerSeverity)
         */
        default Builder newFindings(Consumer<FindingMetricsValuePerSeverity.Builder> newFindings) {
            return newFindings(FindingMetricsValuePerSeverity.builder().applyMutation(newFindings).build());
        }

        /**
         * <p>
         * The number of closed findings of each severity on the specified date.
         * </p>
         * 
         * @param closedFindings
         *        The number of closed findings of each severity on the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closedFindings(FindingMetricsValuePerSeverity closedFindings);

        /**
         * <p>
         * The number of closed findings of each severity on the specified date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingMetricsValuePerSeverity.Builder}
         * avoiding the need to create one manually via {@link FindingMetricsValuePerSeverity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingMetricsValuePerSeverity.Builder#build()} is called
         * immediately and its result is passed to {@link #closedFindings(FindingMetricsValuePerSeverity)}.
         * 
         * @param closedFindings
         *        a consumer that will call methods on {@link FindingMetricsValuePerSeverity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closedFindings(FindingMetricsValuePerSeverity)
         */
        default Builder closedFindings(Consumer<FindingMetricsValuePerSeverity.Builder> closedFindings) {
            return closedFindings(FindingMetricsValuePerSeverity.builder().applyMutation(closedFindings).build());
        }

        /**
         * <p>
         * The number of open findings of each severity as of the specified date.
         * </p>
         * 
         * @param openFindings
         *        The number of open findings of each severity as of the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openFindings(FindingMetricsValuePerSeverity openFindings);

        /**
         * <p>
         * The number of open findings of each severity as of the specified date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingMetricsValuePerSeverity.Builder}
         * avoiding the need to create one manually via {@link FindingMetricsValuePerSeverity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingMetricsValuePerSeverity.Builder#build()} is called
         * immediately and its result is passed to {@link #openFindings(FindingMetricsValuePerSeverity)}.
         * 
         * @param openFindings
         *        a consumer that will call methods on {@link FindingMetricsValuePerSeverity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openFindings(FindingMetricsValuePerSeverity)
         */
        default Builder openFindings(Consumer<FindingMetricsValuePerSeverity.Builder> openFindings) {
            return openFindings(FindingMetricsValuePerSeverity.builder().applyMutation(openFindings).build());
        }

        /**
         * <p>
         * The average time in days it takes to close findings of each severity as of a specified date.
         * </p>
         * 
         * @param meanTimeToClose
         *        The average time in days it takes to close findings of each severity as of a specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meanTimeToClose(FindingMetricsValuePerSeverity meanTimeToClose);

        /**
         * <p>
         * The average time in days it takes to close findings of each severity as of a specified date.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingMetricsValuePerSeverity.Builder}
         * avoiding the need to create one manually via {@link FindingMetricsValuePerSeverity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingMetricsValuePerSeverity.Builder#build()} is called
         * immediately and its result is passed to {@link #meanTimeToClose(FindingMetricsValuePerSeverity)}.
         * 
         * @param meanTimeToClose
         *        a consumer that will call methods on {@link FindingMetricsValuePerSeverity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meanTimeToClose(FindingMetricsValuePerSeverity)
         */
        default Builder meanTimeToClose(Consumer<FindingMetricsValuePerSeverity.Builder> meanTimeToClose) {
            return meanTimeToClose(FindingMetricsValuePerSeverity.builder().applyMutation(meanTimeToClose).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private FindingMetricsValuePerSeverity newFindings;

        private FindingMetricsValuePerSeverity closedFindings;

        private FindingMetricsValuePerSeverity openFindings;

        private FindingMetricsValuePerSeverity meanTimeToClose;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountFindingsMetric model) {
            date(model.date);
            newFindings(model.newFindings);
            closedFindings(model.closedFindings);
            openFindings(model.openFindings);
            meanTimeToClose(model.meanTimeToClose);
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getNewFindings() {
            return newFindings != null ? newFindings.toBuilder() : null;
        }

        public final void setNewFindings(FindingMetricsValuePerSeverity.BuilderImpl newFindings) {
            this.newFindings = newFindings != null ? newFindings.build() : null;
        }

        @Override
        public final Builder newFindings(FindingMetricsValuePerSeverity newFindings) {
            this.newFindings = newFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getClosedFindings() {
            return closedFindings != null ? closedFindings.toBuilder() : null;
        }

        public final void setClosedFindings(FindingMetricsValuePerSeverity.BuilderImpl closedFindings) {
            this.closedFindings = closedFindings != null ? closedFindings.build() : null;
        }

        @Override
        public final Builder closedFindings(FindingMetricsValuePerSeverity closedFindings) {
            this.closedFindings = closedFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getOpenFindings() {
            return openFindings != null ? openFindings.toBuilder() : null;
        }

        public final void setOpenFindings(FindingMetricsValuePerSeverity.BuilderImpl openFindings) {
            this.openFindings = openFindings != null ? openFindings.build() : null;
        }

        @Override
        public final Builder openFindings(FindingMetricsValuePerSeverity openFindings) {
            this.openFindings = openFindings;
            return this;
        }

        public final FindingMetricsValuePerSeverity.Builder getMeanTimeToClose() {
            return meanTimeToClose != null ? meanTimeToClose.toBuilder() : null;
        }

        public final void setMeanTimeToClose(FindingMetricsValuePerSeverity.BuilderImpl meanTimeToClose) {
            this.meanTimeToClose = meanTimeToClose != null ? meanTimeToClose.build() : null;
        }

        @Override
        public final Builder meanTimeToClose(FindingMetricsValuePerSeverity meanTimeToClose) {
            this.meanTimeToClose = meanTimeToClose;
            return this;
        }

        @Override
        public AccountFindingsMetric build() {
            return new AccountFindingsMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
