/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeLine
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeLine> {
    private static final SdkField<Integer> NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("number").getter(CodeLine.getter(CodeLine::number)).setter(CodeLine.setter(Builder::number)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(CodeLine.getter(CodeLine::content)).setter(CodeLine.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeLine.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer number;
    private final String content;

    private CodeLine(BuilderImpl builder) {
        this.number = builder.number;
        this.content = builder.content;
    }

    public final Integer number() {
        return this.number;
    }

    public final String content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.number());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeLine)) {
            return false;
        }
        CodeLine other = (CodeLine)obj;
        return Objects.equals(this.number(), other.number()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"CodeLine").add("Number", (Object)this.number()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "number": {
                return Optional.ofNullable(clazz.cast(this.number()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", NUMBER_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeLine, T> g) {
        return obj -> g.apply((CodeLine)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer number;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeLine model) {
            this.number(model.number);
            this.content(model.content);
        }

        public final Integer getNumber() {
            return this.number;
        }

        public final void setNumber(Integer number) {
            this.number = number;
        }

        @Override
        public final Builder number(Integer number) {
            this.number = number;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public CodeLine build() {
            return new CodeLine(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeLine> {
        public Builder number(Integer var1);

        public Builder content(String var1);
    }
}

