/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurusecurity.model.CodeGuruSecurityResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ResourceId;
import software.amazon.awssdk.services.codegurusecurity.model.ScanState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScanResponse
extends CodeGuruSecurityResponse
implements ToCopyableBuilder<Builder, CreateScanResponse> {
    private static final SdkField<ResourceId> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceId").getter(CreateScanResponse.getter(CreateScanResponse::resourceId)).setter(CreateScanResponse.setter(Builder::resourceId)).constructor(ResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(CreateScanResponse.getter(CreateScanResponse::runId)).setter(CreateScanResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanName").getter(CreateScanResponse.getter(CreateScanResponse::scanName)).setter(CreateScanResponse.setter(Builder::scanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()}).build();
    private static final SdkField<String> SCAN_NAME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanNameArn").getter(CreateScanResponse.getter(CreateScanResponse::scanNameArn)).setter(CreateScanResponse.setter(Builder::scanNameArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameArn").build()}).build();
    private static final SdkField<String> SCAN_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanState").getter(CreateScanResponse.getter(CreateScanResponse::scanStateAsString)).setter(CreateScanResponse.setter(Builder::scanState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RUN_ID_FIELD, SCAN_NAME_FIELD, SCAN_NAME_ARN_FIELD, SCAN_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScanResponse.memberNameToFieldInitializer();
    private final ResourceId resourceId;
    private final String runId;
    private final String scanName;
    private final String scanNameArn;
    private final String scanState;

    private CreateScanResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.runId = builder.runId;
        this.scanName = builder.scanName;
        this.scanNameArn = builder.scanNameArn;
        this.scanState = builder.scanState;
    }

    public final ResourceId resourceId() {
        return this.resourceId;
    }

    public final String runId() {
        return this.runId;
    }

    public final String scanName() {
        return this.scanName;
    }

    public final String scanNameArn() {
        return this.scanNameArn;
    }

    public final ScanState scanState() {
        return ScanState.fromValue(this.scanState);
    }

    public final String scanStateAsString() {
        return this.scanState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScanResponse)) {
            return false;
        }
        CreateScanResponse other = (CreateScanResponse)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.scanName(), other.scanName()) && Objects.equals(this.scanNameArn(), other.scanNameArn()) && Objects.equals(this.scanStateAsString(), other.scanStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScanResponse").add("ResourceId", (Object)this.resourceId()).add("RunId", (Object)this.runId()).add("ScanName", (Object)this.scanName()).add("ScanNameArn", (Object)this.scanNameArn()).add("ScanState", (Object)this.scanStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "scanName": {
                return Optional.ofNullable(clazz.cast(this.scanName()));
            }
            case "scanNameArn": {
                return Optional.ofNullable(clazz.cast(this.scanNameArn()));
            }
            case "scanState": {
                return Optional.ofNullable(clazz.cast(this.scanStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("scanNameArn", SCAN_NAME_ARN_FIELD);
        map.put("scanState", SCAN_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScanResponse, T> g) {
        return obj -> g.apply((CreateScanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruSecurityResponse.BuilderImpl
    implements Builder {
        private ResourceId resourceId;
        private String runId;
        private String scanName;
        private String scanNameArn;
        private String scanState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScanResponse model) {
            super(model);
            this.resourceId(model.resourceId);
            this.runId(model.runId);
            this.scanName(model.scanName);
            this.scanNameArn(model.scanNameArn);
            this.scanState(model.scanState);
        }

        public final ResourceId.Builder getResourceId() {
            return this.resourceId != null ? this.resourceId.toBuilder() : null;
        }

        public final void setResourceId(ResourceId.BuilderImpl resourceId) {
            this.resourceId = resourceId != null ? resourceId.build() : null;
        }

        @Override
        public final Builder resourceId(ResourceId resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getScanName() {
            return this.scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScanNameArn() {
            return this.scanNameArn;
        }

        public final void setScanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
        }

        @Override
        public final Builder scanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
            return this;
        }

        public final String getScanState() {
            return this.scanState;
        }

        public final void setScanState(String scanState) {
            this.scanState = scanState;
        }

        @Override
        public final Builder scanState(String scanState) {
            this.scanState = scanState;
            return this;
        }

        @Override
        public final Builder scanState(ScanState scanState) {
            this.scanState(scanState == null ? null : scanState.toString());
            return this;
        }

        @Override
        public CreateScanResponse build() {
            return new CreateScanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruSecurityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScanResponse> {
        public Builder resourceId(ResourceId var1);

        default public Builder resourceId(Consumer<ResourceId.Builder> resourceId) {
            return this.resourceId((ResourceId)((ResourceId.Builder)ResourceId.builder().applyMutation(resourceId)).build());
        }

        public Builder runId(String var1);

        public Builder scanName(String var1);

        public Builder scanNameArn(String var1);

        public Builder scanState(String var1);

        public Builder scanState(ScanState var1);
    }
}

