/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountConfigurationRequest extends CodeGuruSecurityRequest implements
        ToCopyableBuilder<UpdateAccountConfigurationRequest.Builder, UpdateAccountConfigurationRequest> {
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("encryptionConfig")
            .getter(getter(UpdateAccountConfigurationRequest::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EncryptionConfig encryptionConfig;

    private UpdateAccountConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionConfig = builder.encryptionConfig;
    }

    /**
     * <p>
     * The customer-managed KMS key ARN you want to use for encryption. If not specified, CodeGuru Security will use an
     * AWS-managed key for encryption. If you previously specified a customer-managed KMS key and want CodeGuru Security
     * to use an AWS-managed key for encryption instead, pass nothing.
     * </p>
     * 
     * @return The customer-managed KMS key ARN you want to use for encryption. If not specified, CodeGuru Security will
     *         use an AWS-managed key for encryption. If you previously specified a customer-managed KMS key and want
     *         CodeGuru Security to use an AWS-managed key for encryption instead, pass nothing.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountConfigurationRequest)) {
            return false;
        }
        UpdateAccountConfigurationRequest other = (UpdateAccountConfigurationRequest) obj;
        return Objects.equals(encryptionConfig(), other.encryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountConfigurationRequest").add("EncryptionConfig", encryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionConfig", ENCRYPTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAccountConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountConfigurationRequest> {
        /**
         * <p>
         * The customer-managed KMS key ARN you want to use for encryption. If not specified, CodeGuru Security will use
         * an AWS-managed key for encryption. If you previously specified a customer-managed KMS key and want CodeGuru
         * Security to use an AWS-managed key for encryption instead, pass nothing.
         * </p>
         * 
         * @param encryptionConfig
         *        The customer-managed KMS key ARN you want to use for encryption. If not specified, CodeGuru Security
         *        will use an AWS-managed key for encryption. If you previously specified a customer-managed KMS key and
         *        want CodeGuru Security to use an AWS-managed key for encryption instead, pass nothing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * The customer-managed KMS key ARN you want to use for encryption. If not specified, CodeGuru Security will use
         * an AWS-managed key for encryption. If you previously specified a customer-managed KMS key and want CodeGuru
         * Security to use an AWS-managed key for encryption instead, pass nothing.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfig.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruSecurityRequest.BuilderImpl implements Builder {
        private EncryptionConfig encryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountConfigurationRequest model) {
            super(model);
            encryptionConfig(model.encryptionConfig);
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountConfigurationRequest build() {
            return new UpdateAccountConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
