/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of findings generated by a scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanNameWithFindingNum implements SdkPojo, Serializable,
        ToCopyableBuilder<ScanNameWithFindingNum.Builder, ScanNameWithFindingNum> {
    private static final SdkField<Integer> FINDING_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("findingNumber").getter(getter(ScanNameWithFindingNum::findingNumber))
            .setter(setter(Builder::findingNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingNumber").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(ScanNameWithFindingNum::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_NUMBER_FIELD,
            SCAN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer findingNumber;

    private final String scanName;

    private ScanNameWithFindingNum(BuilderImpl builder) {
        this.findingNumber = builder.findingNumber;
        this.scanName = builder.scanName;
    }

    /**
     * <p>
     * The number of findings generated by a scan.
     * </p>
     * 
     * @return The number of findings generated by a scan.
     */
    public final Integer findingNumber() {
        return findingNumber;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @return The name of the scan.
     */
    public final String scanName() {
        return scanName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingNumber());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanNameWithFindingNum)) {
            return false;
        }
        ScanNameWithFindingNum other = (ScanNameWithFindingNum) obj;
        return Objects.equals(findingNumber(), other.findingNumber()) && Objects.equals(scanName(), other.scanName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanNameWithFindingNum").add("FindingNumber", findingNumber()).add("ScanName", scanName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingNumber":
            return Optional.ofNullable(clazz.cast(findingNumber()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("findingNumber", FINDING_NUMBER_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanNameWithFindingNum, T> g) {
        return obj -> g.apply((ScanNameWithFindingNum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanNameWithFindingNum> {
        /**
         * <p>
         * The number of findings generated by a scan.
         * </p>
         * 
         * @param findingNumber
         *        The number of findings generated by a scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingNumber(Integer findingNumber);

        /**
         * <p>
         * The name of the scan.
         * </p>
         * 
         * @param scanName
         *        The name of the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);
    }

    static final class BuilderImpl implements Builder {
        private Integer findingNumber;

        private String scanName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanNameWithFindingNum model) {
            findingNumber(model.findingNumber);
            scanName(model.scanName);
        }

        public final Integer getFindingNumber() {
            return findingNumber;
        }

        public final void setFindingNumber(Integer findingNumber) {
            this.findingNumber = findingNumber;
        }

        @Override
        public final Builder findingNumber(Integer findingNumber) {
            this.findingNumber = findingNumber;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        @Override
        public ScanNameWithFindingNum build() {
            return new ScanNameWithFindingNum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
