/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how to remediate a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Remediation implements SdkPojo, Serializable, ToCopyableBuilder<Remediation.Builder, Remediation> {
    private static final SdkField<Recommendation> RECOMMENDATION_FIELD = SdkField
            .<Recommendation> builder(MarshallingType.SDK_POJO).memberName("recommendation")
            .getter(getter(Remediation::recommendation)).setter(setter(Builder::recommendation))
            .constructor(Recommendation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<List<SuggestedFix>> SUGGESTED_FIXES_FIELD = SdkField
            .<List<SuggestedFix>> builder(MarshallingType.LIST)
            .memberName("suggestedFixes")
            .getter(getter(Remediation::suggestedFixes))
            .setter(setter(Builder::suggestedFixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedFixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuggestedFix> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuggestedFix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_FIELD,
            SUGGESTED_FIXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Recommendation recommendation;

    private final List<SuggestedFix> suggestedFixes;

    private Remediation(BuilderImpl builder) {
        this.recommendation = builder.recommendation;
        this.suggestedFixes = builder.suggestedFixes;
    }

    /**
     * <p>
     * An object that contains information about the recommended course of action to remediate a finding.
     * </p>
     * 
     * @return An object that contains information about the recommended course of action to remediate a finding.
     */
    public final Recommendation recommendation() {
        return recommendation;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestedFixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestedFixes() {
        return suggestedFixes != null && !(suggestedFixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code fix to
     * remediate the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestedFixes} method.
     * </p>
     * 
     * @return A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code fix
     *         to remediate the finding.
     */
    public final List<SuggestedFix> suggestedFixes() {
        return suggestedFixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestedFixes() ? suggestedFixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Remediation)) {
            return false;
        }
        Remediation other = (Remediation) obj;
        return Objects.equals(recommendation(), other.recommendation()) && hasSuggestedFixes() == other.hasSuggestedFixes()
                && Objects.equals(suggestedFixes(), other.suggestedFixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Remediation").add("Recommendation", recommendation())
                .add("SuggestedFixes", hasSuggestedFixes() ? suggestedFixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "suggestedFixes":
            return Optional.ofNullable(clazz.cast(suggestedFixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("suggestedFixes", SUGGESTED_FIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Remediation, T> g) {
        return obj -> g.apply((Remediation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Remediation> {
        /**
         * <p>
         * An object that contains information about the recommended course of action to remediate a finding.
         * </p>
         * 
         * @param recommendation
         *        An object that contains information about the recommended course of action to remediate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(Recommendation recommendation);

        /**
         * <p>
         * An object that contains information about the recommended course of action to remediate a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Recommendation.Builder} avoiding the need
         * to create one manually via {@link Recommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Recommendation.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendation(Recommendation)}.
         * 
         * @param recommendation
         *        a consumer that will call methods on {@link Recommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendation(Recommendation)
         */
        default Builder recommendation(Consumer<Recommendation.Builder> recommendation) {
            return recommendation(Recommendation.builder().applyMutation(recommendation).build());
        }

        /**
         * <p>
         * A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code fix to
         * remediate the finding.
         * </p>
         * 
         * @param suggestedFixes
         *        A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code
         *        fix to remediate the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedFixes(Collection<SuggestedFix> suggestedFixes);

        /**
         * <p>
         * A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code fix to
         * remediate the finding.
         * </p>
         * 
         * @param suggestedFixes
         *        A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code
         *        fix to remediate the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedFixes(SuggestedFix... suggestedFixes);

        /**
         * <p>
         * A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code fix to
         * remediate the finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix.Builder#build()} is called
         * immediately and its result is passed to {@link #suggestedFixes(List<SuggestedFix>)}.
         * 
         * @param suggestedFixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.SuggestedFix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestedFixes(java.util.Collection<SuggestedFix>)
         */
        Builder suggestedFixes(Consumer<SuggestedFix.Builder>... suggestedFixes);
    }

    static final class BuilderImpl implements Builder {
        private Recommendation recommendation;

        private List<SuggestedFix> suggestedFixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Remediation model) {
            recommendation(model.recommendation);
            suggestedFixes(model.suggestedFixes);
        }

        public final Recommendation.Builder getRecommendation() {
            return recommendation != null ? recommendation.toBuilder() : null;
        }

        public final void setRecommendation(Recommendation.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(Recommendation recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final List<SuggestedFix.Builder> getSuggestedFixes() {
            List<SuggestedFix.Builder> result = SuggestedFixesCopier.copyToBuilder(this.suggestedFixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestedFixes(Collection<SuggestedFix.BuilderImpl> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copyFromBuilder(suggestedFixes);
        }

        @Override
        public final Builder suggestedFixes(Collection<SuggestedFix> suggestedFixes) {
            this.suggestedFixes = SuggestedFixesCopier.copy(suggestedFixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(SuggestedFix... suggestedFixes) {
            suggestedFixes(Arrays.asList(suggestedFixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedFixes(Consumer<SuggestedFix.Builder>... suggestedFixes) {
            suggestedFixes(Stream.of(suggestedFixes).map(c -> SuggestedFix.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Remediation build() {
            return new Remediation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
