/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsMetricsResponse extends CodeGuruSecurityResponse implements
        ToCopyableBuilder<ListFindingsMetricsResponse.Builder, ListFindingsMetricsResponse> {
    private static final SdkField<List<AccountFindingsMetric>> FINDINGS_METRICS_FIELD = SdkField
            .<List<AccountFindingsMetric>> builder(MarshallingType.LIST)
            .memberName("findingsMetrics")
            .getter(getter(ListFindingsMetricsResponse::findingsMetrics))
            .setter(setter(Builder::findingsMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountFindingsMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountFindingsMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_METRICS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccountFindingsMetric> findingsMetrics;

    private final String nextToken;

    private ListFindingsMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.findingsMetrics = builder.findingsMetrics;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingsMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingsMetrics() {
        return findingsMetrics != null && !(findingsMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingsMetrics} method.
     * </p>
     * 
     * @return A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
     */
    public final List<AccountFindingsMetric> findingsMetrics() {
        return findingsMetrics;
    }

    /**
     * <p>
     * A pagination token. You can use this in future calls to <code>ListFindingMetrics</code> to continue listing
     * results after the current page.
     * </p>
     * 
     * @return A pagination token. You can use this in future calls to <code>ListFindingMetrics</code> to continue
     *         listing results after the current page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingsMetrics() ? findingsMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsMetricsResponse)) {
            return false;
        }
        ListFindingsMetricsResponse other = (ListFindingsMetricsResponse) obj;
        return hasFindingsMetrics() == other.hasFindingsMetrics() && Objects.equals(findingsMetrics(), other.findingsMetrics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsMetricsResponse")
                .add("FindingsMetrics", hasFindingsMetrics() ? findingsMetrics() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingsMetrics":
            return Optional.ofNullable(clazz.cast(findingsMetrics()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("findingsMetrics", FINDINGS_METRICS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsMetricsResponse, T> g) {
        return obj -> g.apply((ListFindingsMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFindingsMetricsResponse> {
        /**
         * <p>
         * A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
         * </p>
         * 
         * @param findingsMetrics
         *        A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsMetrics(Collection<AccountFindingsMetric> findingsMetrics);

        /**
         * <p>
         * A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
         * </p>
         * 
         * @param findingsMetrics
         *        A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsMetrics(AccountFindingsMetric... findingsMetrics);

        /**
         * <p>
         * A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric.Builder#build()} is
         * called immediately and its result is passed to {@link #findingsMetrics(List<AccountFindingsMetric>)}.
         * 
         * @param findingsMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingsMetrics(java.util.Collection<AccountFindingsMetric>)
         */
        Builder findingsMetrics(Consumer<AccountFindingsMetric.Builder>... findingsMetrics);

        /**
         * <p>
         * A pagination token. You can use this in future calls to <code>ListFindingMetrics</code> to continue listing
         * results after the current page.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. You can use this in future calls to <code>ListFindingMetrics</code> to continue
         *        listing results after the current page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeGuruSecurityResponse.BuilderImpl implements Builder {
        private List<AccountFindingsMetric> findingsMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsMetricsResponse model) {
            super(model);
            findingsMetrics(model.findingsMetrics);
            nextToken(model.nextToken);
        }

        public final List<AccountFindingsMetric.Builder> getFindingsMetrics() {
            List<AccountFindingsMetric.Builder> result = FindingsMetricListCopier.copyToBuilder(this.findingsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingsMetrics(Collection<AccountFindingsMetric.BuilderImpl> findingsMetrics) {
            this.findingsMetrics = FindingsMetricListCopier.copyFromBuilder(findingsMetrics);
        }

        @Override
        public final Builder findingsMetrics(Collection<AccountFindingsMetric> findingsMetrics) {
            this.findingsMetrics = FindingsMetricListCopier.copy(findingsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsMetrics(AccountFindingsMetric... findingsMetrics) {
            findingsMetrics(Arrays.asList(findingsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsMetrics(Consumer<AccountFindingsMetric.Builder>... findingsMetrics) {
            findingsMetrics(Stream.of(findingsMetrics).map(c -> AccountFindingsMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFindingsMetricsResponse build() {
            return new ListFindingsMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
