/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScanResponse extends CodeGuruSecurityResponse implements
        ToCopyableBuilder<GetScanResponse.Builder, GetScanResponse> {
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisType").getter(getter(GetScanResponse::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetScanResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(GetScanResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<Long> NUMBER_OF_REVISIONS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfRevisions").getter(getter(GetScanResponse::numberOfRevisions))
            .setter(setter(Builder::numberOfRevisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRevisions").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(GetScanResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(GetScanResponse::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<String> SCAN_NAME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanNameArn").getter(getter(GetScanResponse::scanNameArn)).setter(setter(Builder::scanNameArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameArn").build()).build();

    private static final SdkField<String> SCAN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanState").getter(getter(GetScanResponse::scanStateAsString)).setter(setter(Builder::scanState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanState").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetScanResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_TYPE_FIELD,
            CREATED_AT_FIELD, ERROR_MESSAGE_FIELD, NUMBER_OF_REVISIONS_FIELD, RUN_ID_FIELD, SCAN_NAME_FIELD, SCAN_NAME_ARN_FIELD,
            SCAN_STATE_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String analysisType;

    private final Instant createdAt;

    private final String errorMessage;

    private final Long numberOfRevisions;

    private final String runId;

    private final String scanName;

    private final String scanNameArn;

    private final String scanState;

    private final Instant updatedAt;

    private GetScanResponse(BuilderImpl builder) {
        super(builder);
        this.analysisType = builder.analysisType;
        this.createdAt = builder.createdAt;
        this.errorMessage = builder.errorMessage;
        this.numberOfRevisions = builder.numberOfRevisions;
        this.runId = builder.runId;
        this.scanName = builder.scanName;
        this.scanNameArn = builder.scanNameArn;
        this.scanState = builder.scanState;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or <code>All</code>.
     * The <code>Security</code> type only generates findings related to security. The <code>All</code> type generates
     * both security findings and quality findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or
     *         <code>All</code>. The <code>Security</code> type only generates findings related to security. The
     *         <code>All</code> type generates both security findings and quality findings.
     * @see AnalysisType
     */
    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or <code>All</code>.
     * The <code>Security</code> type only generates findings related to security. The <code>All</code> type generates
     * both security findings and quality findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or
     *         <code>All</code>. The <code>Security</code> type only generates findings related to security. The
     *         <code>All</code> type generates both security findings and quality findings.
     * @see AnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * <p>
     * The time the scan was created.
     * </p>
     * 
     * @return The time the scan was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Details about the error that causes a scan to fail to be retrieved.
     * </p>
     * 
     * @return Details about the error that causes a scan to fail to be retrieved.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The number of times a scan has been re-run on a revised resource.
     * </p>
     * 
     * @return The number of times a scan has been re-run on a revised resource.
     */
    public final Long numberOfRevisions() {
        return numberOfRevisions;
    }

    /**
     * <p>
     * UUID that identifies the individual scan run.
     * </p>
     * 
     * @return UUID that identifies the individual scan run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @return The name of the scan.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The ARN for the scan name.
     * </p>
     * 
     * @return The ARN for the scan name.
     */
    public final String scanNameArn() {
        return scanNameArn;
    }

    /**
     * <p>
     * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanStateAsString}.
     * </p>
     * 
     * @return The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     *         <code>Failed</code>.
     * @see ScanState
     */
    public final ScanState scanState() {
        return ScanState.fromValue(scanState);
    }

    /**
     * <p>
     * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanStateAsString}.
     * </p>
     * 
     * @return The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     *         <code>Failed</code>.
     * @see ScanState
     */
    public final String scanStateAsString() {
        return scanState;
    }

    /**
     * <p>
     * The time when the scan was last updated. Only available for <code>STANDARD</code> scan types.
     * </p>
     * 
     * @return The time when the scan was last updated. Only available for <code>STANDARD</code> scan types.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRevisions());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(scanNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScanResponse)) {
            return false;
        }
        GetScanResponse other = (GetScanResponse) obj;
        return Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(numberOfRevisions(), other.numberOfRevisions()) && Objects.equals(runId(), other.runId())
                && Objects.equals(scanName(), other.scanName()) && Objects.equals(scanNameArn(), other.scanNameArn())
                && Objects.equals(scanStateAsString(), other.scanStateAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScanResponse").add("AnalysisType", analysisTypeAsString()).add("CreatedAt", createdAt())
                .add("ErrorMessage", errorMessage()).add("NumberOfRevisions", numberOfRevisions()).add("RunId", runId())
                .add("ScanName", scanName()).add("ScanNameArn", scanNameArn()).add("ScanState", scanStateAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "numberOfRevisions":
            return Optional.ofNullable(clazz.cast(numberOfRevisions()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "scanNameArn":
            return Optional.ofNullable(clazz.cast(scanNameArn()));
        case "scanState":
            return Optional.ofNullable(clazz.cast(scanStateAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisType", ANALYSIS_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("numberOfRevisions", NUMBER_OF_REVISIONS_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("scanNameArn", SCAN_NAME_ARN_FIELD);
        map.put("scanState", SCAN_STATE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScanResponse, T> g) {
        return obj -> g.apply((GetScanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetScanResponse> {
        /**
         * <p>
         * The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or
         * <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         * <code>All</code> type generates both security findings and quality findings.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or
         *        <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         *        <code>All</code> type generates both security findings and quality findings.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or
         * <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         * <code>All</code> type generates both security findings and quality findings.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or
         *        <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         *        <code>All</code> type generates both security findings and quality findings.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(AnalysisType analysisType);

        /**
         * <p>
         * The time the scan was created.
         * </p>
         * 
         * @param createdAt
         *        The time the scan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Details about the error that causes a scan to fail to be retrieved.
         * </p>
         * 
         * @param errorMessage
         *        Details about the error that causes a scan to fail to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The number of times a scan has been re-run on a revised resource.
         * </p>
         * 
         * @param numberOfRevisions
         *        The number of times a scan has been re-run on a revised resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRevisions(Long numberOfRevisions);

        /**
         * <p>
         * UUID that identifies the individual scan run.
         * </p>
         * 
         * @param runId
         *        UUID that identifies the individual scan run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of the scan.
         * </p>
         * 
         * @param scanName
         *        The name of the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The ARN for the scan name.
         * </p>
         * 
         * @param scanNameArn
         *        The ARN for the scan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameArn(String scanNameArn);

        /**
         * <p>
         * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         * <code>Failed</code>.
         * </p>
         * 
         * @param scanState
         *        The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         *        <code>Failed</code>.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder scanState(String scanState);

        /**
         * <p>
         * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         * <code>Failed</code>.
         * </p>
         * 
         * @param scanState
         *        The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         *        <code>Failed</code>.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder scanState(ScanState scanState);

        /**
         * <p>
         * The time when the scan was last updated. Only available for <code>STANDARD</code> scan types.
         * </p>
         * 
         * @param updatedAt
         *        The time when the scan was last updated. Only available for <code>STANDARD</code> scan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends CodeGuruSecurityResponse.BuilderImpl implements Builder {
        private String analysisType;

        private Instant createdAt;

        private String errorMessage;

        private Long numberOfRevisions;

        private String runId;

        private String scanName;

        private String scanNameArn;

        private String scanState;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScanResponse model) {
            super(model);
            analysisType(model.analysisType);
            createdAt(model.createdAt);
            errorMessage(model.errorMessage);
            numberOfRevisions(model.numberOfRevisions);
            runId(model.runId);
            scanName(model.scanName);
            scanNameArn(model.scanNameArn);
            scanState(model.scanState);
            updatedAt(model.updatedAt);
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Long getNumberOfRevisions() {
            return numberOfRevisions;
        }

        public final void setNumberOfRevisions(Long numberOfRevisions) {
            this.numberOfRevisions = numberOfRevisions;
        }

        @Override
        public final Builder numberOfRevisions(Long numberOfRevisions) {
            this.numberOfRevisions = numberOfRevisions;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScanNameArn() {
            return scanNameArn;
        }

        public final void setScanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
        }

        @Override
        public final Builder scanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
            return this;
        }

        public final String getScanState() {
            return scanState;
        }

        public final void setScanState(String scanState) {
            this.scanState = scanState;
        }

        @Override
        public final Builder scanState(String scanState) {
            this.scanState = scanState;
            return this;
        }

        @Override
        public final Builder scanState(ScanState scanState) {
            this.scanState(scanState == null ? null : scanState.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetScanResponse build() {
            return new GetScanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
