/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A numeric value corresponding to the severity of a finding, such as the number of open findings or the average time
 * it takes to close findings of a given severity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingMetricsValuePerSeverity implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingMetricsValuePerSeverity.Builder, FindingMetricsValuePerSeverity> {
    private static final SdkField<Double> CRITICAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("critical").getter(getter(FindingMetricsValuePerSeverity::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("critical").build()).build();

    private static final SdkField<Double> HIGH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("high")
            .getter(getter(FindingMetricsValuePerSeverity::high)).setter(setter(Builder::high))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("high").build()).build();

    private static final SdkField<Double> INFO_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("info")
            .getter(getter(FindingMetricsValuePerSeverity::info)).setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("info").build()).build();

    private static final SdkField<Double> LOW_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("low")
            .getter(getter(FindingMetricsValuePerSeverity::low)).setter(setter(Builder::low))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("low").build()).build();

    private static final SdkField<Double> MEDIUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("medium")
            .getter(getter(FindingMetricsValuePerSeverity::medium)).setter(setter(Builder::medium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("medium").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITICAL_FIELD, HIGH_FIELD,
            INFO_FIELD, LOW_FIELD, MEDIUM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double critical;

    private final Double high;

    private final Double info;

    private final Double low;

    private final Double medium;

    private FindingMetricsValuePerSeverity(BuilderImpl builder) {
        this.critical = builder.critical;
        this.high = builder.high;
        this.info = builder.info;
        this.low = builder.low;
        this.medium = builder.medium;
    }

    /**
     * <p>
     * A numeric value corresponding to a critical finding.
     * </p>
     * 
     * @return A numeric value corresponding to a critical finding.
     */
    public final Double critical() {
        return critical;
    }

    /**
     * <p>
     * A numeric value corresponding to a high severity finding.
     * </p>
     * 
     * @return A numeric value corresponding to a high severity finding.
     */
    public final Double high() {
        return high;
    }

    /**
     * <p>
     * A numeric value corresponding to an informational finding.
     * </p>
     * 
     * @return A numeric value corresponding to an informational finding.
     */
    public final Double info() {
        return info;
    }

    /**
     * <p>
     * A numeric value corresponding to a low severity finding.
     * </p>
     * 
     * @return A numeric value corresponding to a low severity finding.
     */
    public final Double low() {
        return low;
    }

    /**
     * <p>
     * A numeric value corresponding to a medium severity finding.
     * </p>
     * 
     * @return A numeric value corresponding to a medium severity finding.
     */
    public final Double medium() {
        return medium;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        hashCode = 31 * hashCode + Objects.hashCode(high());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        hashCode = 31 * hashCode + Objects.hashCode(low());
        hashCode = 31 * hashCode + Objects.hashCode(medium());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingMetricsValuePerSeverity)) {
            return false;
        }
        FindingMetricsValuePerSeverity other = (FindingMetricsValuePerSeverity) obj;
        return Objects.equals(critical(), other.critical()) && Objects.equals(high(), other.high())
                && Objects.equals(info(), other.info()) && Objects.equals(low(), other.low())
                && Objects.equals(medium(), other.medium());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingMetricsValuePerSeverity").add("Critical", critical()).add("High", high())
                .add("Info", info()).add("Low", low()).add("Medium", medium()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "critical":
            return Optional.ofNullable(clazz.cast(critical()));
        case "high":
            return Optional.ofNullable(clazz.cast(high()));
        case "info":
            return Optional.ofNullable(clazz.cast(info()));
        case "low":
            return Optional.ofNullable(clazz.cast(low()));
        case "medium":
            return Optional.ofNullable(clazz.cast(medium()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("critical", CRITICAL_FIELD);
        map.put("high", HIGH_FIELD);
        map.put("info", INFO_FIELD);
        map.put("low", LOW_FIELD);
        map.put("medium", MEDIUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingMetricsValuePerSeverity, T> g) {
        return obj -> g.apply((FindingMetricsValuePerSeverity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingMetricsValuePerSeverity> {
        /**
         * <p>
         * A numeric value corresponding to a critical finding.
         * </p>
         * 
         * @param critical
         *        A numeric value corresponding to a critical finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Double critical);

        /**
         * <p>
         * A numeric value corresponding to a high severity finding.
         * </p>
         * 
         * @param high
         *        A numeric value corresponding to a high severity finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Double high);

        /**
         * <p>
         * A numeric value corresponding to an informational finding.
         * </p>
         * 
         * @param info
         *        A numeric value corresponding to an informational finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Double info);

        /**
         * <p>
         * A numeric value corresponding to a low severity finding.
         * </p>
         * 
         * @param low
         *        A numeric value corresponding to a low severity finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder low(Double low);

        /**
         * <p>
         * A numeric value corresponding to a medium severity finding.
         * </p>
         * 
         * @param medium
         *        A numeric value corresponding to a medium severity finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medium(Double medium);
    }

    static final class BuilderImpl implements Builder {
        private Double critical;

        private Double high;

        private Double info;

        private Double low;

        private Double medium;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingMetricsValuePerSeverity model) {
            critical(model.critical);
            high(model.high);
            info(model.info);
            low(model.low);
            medium(model.medium);
        }

        public final Double getCritical() {
            return critical;
        }

        public final void setCritical(Double critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Double critical) {
            this.critical = critical;
            return this;
        }

        public final Double getHigh() {
            return high;
        }

        public final void setHigh(Double high) {
            this.high = high;
        }

        @Override
        public final Builder high(Double high) {
            this.high = high;
            return this;
        }

        public final Double getInfo() {
            return info;
        }

        public final void setInfo(Double info) {
            this.info = info;
        }

        @Override
        public final Builder info(Double info) {
            this.info = info;
            return this;
        }

        public final Double getLow() {
            return low;
        }

        public final void setLow(Double low) {
            this.low = low;
        }

        @Override
        public final Builder low(Double low) {
            this.low = low;
            return this;
        }

        public final Double getMedium() {
            return medium;
        }

        public final void setMedium(Double medium) {
            this.medium = medium;
        }

        @Override
        public final Builder medium(Double medium) {
            this.medium = medium;
            return this;
        }

        @Override
        public FindingMetricsValuePerSeverity build() {
            return new FindingMetricsValuePerSeverity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
