/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScanResponse extends CodeGuruSecurityResponse implements
        ToCopyableBuilder<CreateScanResponse.Builder, CreateScanResponse> {
    private static final SdkField<ResourceId> RESOURCE_ID_FIELD = SdkField.<ResourceId> builder(MarshallingType.SDK_POJO)
            .memberName("resourceId").getter(getter(CreateScanResponse::resourceId)).setter(setter(Builder::resourceId))
            .constructor(ResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(CreateScanResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(CreateScanResponse::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<String> SCAN_NAME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanNameArn").getter(getter(CreateScanResponse::scanNameArn)).setter(setter(Builder::scanNameArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameArn").build()).build();

    private static final SdkField<String> SCAN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanState").getter(getter(CreateScanResponse::scanStateAsString)).setter(setter(Builder::scanState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RUN_ID_FIELD, SCAN_NAME_FIELD, SCAN_NAME_ARN_FIELD, SCAN_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourceId resourceId;

    private final String runId;

    private final String scanName;

    private final String scanNameArn;

    private final String scanState;

    private CreateScanResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.runId = builder.runId;
        this.scanName = builder.scanName;
        this.scanNameArn = builder.scanNameArn;
        this.scanState = builder.scanState;
    }

    /**
     * <p>
     * The identifier for the resource object that contains resources that were scanned.
     * </p>
     * 
     * @return The identifier for the resource object that contains resources that were scanned.
     */
    public final ResourceId resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * UUID that identifies the individual scan run.
     * </p>
     * 
     * @return UUID that identifies the individual scan run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @return The name of the scan.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The ARN for the scan name.
     * </p>
     * 
     * @return The ARN for the scan name.
     */
    public final String scanNameArn() {
        return scanNameArn;
    }

    /**
     * <p>
     * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanStateAsString}.
     * </p>
     * 
     * @return The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     *         <code>Failed</code>.
     * @see ScanState
     */
    public final ScanState scanState() {
        return ScanState.fromValue(scanState);
    }

    /**
     * <p>
     * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanStateAsString}.
     * </p>
     * 
     * @return The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
     *         <code>Failed</code>.
     * @see ScanState
     */
    public final String scanStateAsString() {
        return scanState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(scanNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScanResponse)) {
            return false;
        }
        CreateScanResponse other = (CreateScanResponse) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(runId(), other.runId())
                && Objects.equals(scanName(), other.scanName()) && Objects.equals(scanNameArn(), other.scanNameArn())
                && Objects.equals(scanStateAsString(), other.scanStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScanResponse").add("ResourceId", resourceId()).add("RunId", runId())
                .add("ScanName", scanName()).add("ScanNameArn", scanNameArn()).add("ScanState", scanStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "scanNameArn":
            return Optional.ofNullable(clazz.cast(scanNameArn()));
        case "scanState":
            return Optional.ofNullable(clazz.cast(scanStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("scanNameArn", SCAN_NAME_ARN_FIELD);
        map.put("scanState", SCAN_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScanResponse, T> g) {
        return obj -> g.apply((CreateScanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateScanResponse> {
        /**
         * <p>
         * The identifier for the resource object that contains resources that were scanned.
         * </p>
         * 
         * @param resourceId
         *        The identifier for the resource object that contains resources that were scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(ResourceId resourceId);

        /**
         * <p>
         * The identifier for the resource object that contains resources that were scanned.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceId.Builder} avoiding the need to
         * create one manually via {@link ResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceId.Builder#build()} is called immediately and its result
         * is passed to {@link #resourceId(ResourceId)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on {@link ResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(ResourceId)
         */
        default Builder resourceId(Consumer<ResourceId.Builder> resourceId) {
            return resourceId(ResourceId.builder().applyMutation(resourceId).build());
        }

        /**
         * <p>
         * UUID that identifies the individual scan run.
         * </p>
         * 
         * @param runId
         *        UUID that identifies the individual scan run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of the scan.
         * </p>
         * 
         * @param scanName
         *        The name of the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The ARN for the scan name.
         * </p>
         * 
         * @param scanNameArn
         *        The ARN for the scan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameArn(String scanNameArn);

        /**
         * <p>
         * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         * <code>Failed</code>.
         * </p>
         * 
         * @param scanState
         *        The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         *        <code>Failed</code>.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder scanState(String scanState);

        /**
         * <p>
         * The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         * <code>Failed</code>.
         * </p>
         * 
         * @param scanState
         *        The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or
         *        <code>Failed</code>.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder scanState(ScanState scanState);
    }

    static final class BuilderImpl extends CodeGuruSecurityResponse.BuilderImpl implements Builder {
        private ResourceId resourceId;

        private String runId;

        private String scanName;

        private String scanNameArn;

        private String scanState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScanResponse model) {
            super(model);
            resourceId(model.resourceId);
            runId(model.runId);
            scanName(model.scanName);
            scanNameArn(model.scanNameArn);
            scanState(model.scanState);
        }

        public final ResourceId.Builder getResourceId() {
            return resourceId != null ? resourceId.toBuilder() : null;
        }

        public final void setResourceId(ResourceId.BuilderImpl resourceId) {
            this.resourceId = resourceId != null ? resourceId.build() : null;
        }

        @Override
        public final Builder resourceId(ResourceId resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScanNameArn() {
            return scanNameArn;
        }

        public final void setScanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
        }

        @Override
        public final Builder scanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
            return this;
        }

        public final String getScanState() {
            return scanState;
        }

        public final void setScanState(String scanState) {
            this.scanState = scanState;
        }

        @Override
        public final Builder scanState(String scanState) {
            this.scanState = scanState;
            return this;
        }

        @Override
        public final Builder scanState(ScanState scanState) {
            this.scanState(scanState == null ? null : scanState.toString());
            return this;
        }

        @Override
        public CreateScanResponse build() {
            return new CreateScanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
