/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The line of code where a finding was detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeLine implements SdkPojo, Serializable, ToCopyableBuilder<CodeLine.Builder, CodeLine> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(CodeLine::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<Integer> NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("number").getter(getter(CodeLine::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private final Integer number;

    private CodeLine(BuilderImpl builder) {
        this.content = builder.content;
        this.number = builder.number;
    }

    /**
     * <p>
     * The code that contains a vulnerability.
     * </p>
     * 
     * @return The code that contains a vulnerability.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The code line number.
     * </p>
     * 
     * @return The code line number.
     */
    public final Integer number() {
        return number;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(number());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeLine)) {
            return false;
        }
        CodeLine other = (CodeLine) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(number(), other.number());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeLine").add("Content", content()).add("Number", number()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "number":
            return Optional.ofNullable(clazz.cast(number()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("number", NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeLine, T> g) {
        return obj -> g.apply((CodeLine) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeLine> {
        /**
         * <p>
         * The code that contains a vulnerability.
         * </p>
         * 
         * @param content
         *        The code that contains a vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The code line number.
         * </p>
         * 
         * @param number
         *        The code line number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(Integer number);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private Integer number;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeLine model) {
            content(model.content);
            number(model.number);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Integer getNumber() {
            return number;
        }

        public final void setNumber(Integer number) {
            this.number = number;
        }

        @Override
        public final Builder number(Integer number) {
            this.number = number;
            return this;
        }

        @Override
        public CodeLine build() {
            return new CodeLine(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
