/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a security vulnerability that Amazon CodeGuru Security detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vulnerability implements SdkPojo, Serializable, ToCopyableBuilder<Vulnerability.Builder, Vulnerability> {
    private static final SdkField<FilePath> FILE_PATH_FIELD = SdkField.<FilePath> builder(MarshallingType.SDK_POJO)
            .memberName("filePath").getter(getter(Vulnerability::filePath)).setter(setter(Builder::filePath))
            .constructor(FilePath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Vulnerability::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("itemCount").getter(getter(Vulnerability::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemCount").build()).build();

    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("referenceUrls")
            .getter(getter(Vulnerability::referenceUrls))
            .setter(setter(Builder::referenceUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("relatedVulnerabilities")
            .getter(getter(Vulnerability::relatedVulnerabilities))
            .setter(setter(Builder::relatedVulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, ID_FIELD,
            ITEM_COUNT_FIELD, REFERENCE_URLS_FIELD, RELATED_VULNERABILITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final FilePath filePath;

    private final String id;

    private final Integer itemCount;

    private final List<String> referenceUrls;

    private final List<String> relatedVulnerabilities;

    private Vulnerability(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.id = builder.id;
        this.itemCount = builder.itemCount;
        this.referenceUrls = builder.referenceUrls;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
    }

    /**
     * <p>
     * An object that describes the location of the detected security vulnerability in your code.
     * </p>
     * 
     * @return An object that describes the location of the detected security vulnerability in your code.
     */
    public final FilePath filePath() {
        return filePath;
    }

    /**
     * <p>
     * The identifier for the vulnerability.
     * </p>
     * 
     * @return The identifier for the vulnerability.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The number of times the vulnerability appears in your code.
     * </p>
     * 
     * @return The number of times the vulnerability appears in your code.
     * @deprecated This shape is not used.
     */
    @Deprecated
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceUrls() {
        return referenceUrls != null && !(referenceUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more URL addresses that contain details about a vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceUrls} method.
     * </p>
     * 
     * @return One or more URL addresses that contain details about a vulnerability.
     */
    public final List<String> referenceUrls() {
        return referenceUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedVulnerabilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelatedVulnerabilities() {
        return relatedVulnerabilities != null && !(relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more vulnerabilities that are related to the vulnerability being described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedVulnerabilities} method.
     * </p>
     * 
     * @return One or more vulnerabilities that are related to the vulnerability being described.
     */
    public final List<String> relatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceUrls() ? referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedVulnerabilities() ? relatedVulnerabilities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(id(), other.id())
                && Objects.equals(itemCount(), other.itemCount()) && hasReferenceUrls() == other.hasReferenceUrls()
                && Objects.equals(referenceUrls(), other.referenceUrls())
                && hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities()
                && Objects.equals(relatedVulnerabilities(), other.relatedVulnerabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vulnerability").add("FilePath", filePath()).add("Id", id()).add("ItemCount", itemCount())
                .add("ReferenceUrls", hasReferenceUrls() ? referenceUrls() : null)
                .add("RelatedVulnerabilities", hasRelatedVulnerabilities() ? relatedVulnerabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "itemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "referenceUrls":
            return Optional.ofNullable(clazz.cast(referenceUrls()));
        case "relatedVulnerabilities":
            return Optional.ofNullable(clazz.cast(relatedVulnerabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vulnerability, T> g) {
        return obj -> g.apply((Vulnerability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vulnerability> {
        /**
         * <p>
         * An object that describes the location of the detected security vulnerability in your code.
         * </p>
         * 
         * @param filePath
         *        An object that describes the location of the detected security vulnerability in your code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(FilePath filePath);

        /**
         * <p>
         * An object that describes the location of the detected security vulnerability in your code.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilePath.Builder} avoiding the need to
         * create one manually via {@link FilePath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilePath.Builder#build()} is called immediately and its result is
         * passed to {@link #filePath(FilePath)}.
         * 
         * @param filePath
         *        a consumer that will call methods on {@link FilePath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filePath(FilePath)
         */
        default Builder filePath(Consumer<FilePath.Builder> filePath) {
            return filePath(FilePath.builder().applyMutation(filePath).build());
        }

        /**
         * <p>
         * The identifier for the vulnerability.
         * </p>
         * 
         * @param id
         *        The identifier for the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The number of times the vulnerability appears in your code.
         * </p>
         * 
         * @param itemCount
         *        The number of times the vulnerability appears in your code.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This shape is not used.
         */
        @Deprecated
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * One or more URL addresses that contain details about a vulnerability.
         * </p>
         * 
         * @param referenceUrls
         *        One or more URL addresses that contain details about a vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(Collection<String> referenceUrls);

        /**
         * <p>
         * One or more URL addresses that contain details about a vulnerability.
         * </p>
         * 
         * @param referenceUrls
         *        One or more URL addresses that contain details about a vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(String... referenceUrls);

        /**
         * <p>
         * One or more vulnerabilities that are related to the vulnerability being described.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        One or more vulnerabilities that are related to the vulnerability being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities);

        /**
         * <p>
         * One or more vulnerabilities that are related to the vulnerability being described.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        One or more vulnerabilities that are related to the vulnerability being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(String... relatedVulnerabilities);
    }

    static final class BuilderImpl implements Builder {
        private FilePath filePath;

        private String id;

        private Integer itemCount;

        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Vulnerability model) {
            filePath(model.filePath);
            id(model.id);
            itemCount(model.itemCount);
            referenceUrls(model.referenceUrls);
            relatedVulnerabilities(model.relatedVulnerabilities);
        }

        public final FilePath.Builder getFilePath() {
            return filePath != null ? filePath.toBuilder() : null;
        }

        public final void setFilePath(FilePath.BuilderImpl filePath) {
            this.filePath = filePath != null ? filePath.build() : null;
        }

        @Override
        public final Builder filePath(FilePath filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Deprecated
        public final Integer getItemCount() {
            return itemCount;
        }

        @Deprecated
        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        @Deprecated
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = ReferenceUrlsCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String... referenceUrls) {
            referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = RelatedVulnerabilitiesCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = RelatedVulnerabilitiesCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String... relatedVulnerabilities) {
            relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        @Override
        public Vulnerability build() {
            return new Vulnerability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
