/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanSummary implements SdkPojo, Serializable, ToCopyableBuilder<ScanSummary.Builder, ScanSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ScanSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(ScanSummary::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(ScanSummary::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<String> SCAN_NAME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanNameArn").getter(getter(ScanSummary::scanNameArn)).setter(setter(Builder::scanNameArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameArn").build()).build();

    private static final SdkField<String> SCAN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanState").getter(getter(ScanSummary::scanStateAsString)).setter(setter(Builder::scanState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanState").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(ScanSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            RUN_ID_FIELD, SCAN_NAME_FIELD, SCAN_NAME_ARN_FIELD, SCAN_STATE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String runId;

    private final String scanName;

    private final String scanNameArn;

    private final String scanState;

    private final Instant updatedAt;

    private ScanSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.runId = builder.runId;
        this.scanName = builder.scanName;
        this.scanNameArn = builder.scanNameArn;
        this.scanState = builder.scanState;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The time when the scan was created.
     * </p>
     * 
     * @return The time when the scan was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier for the scan run.
     * </p>
     * 
     * @return The identifier for the scan run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The name of the scan.
     * </p>
     * 
     * @return The name of the scan.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The ARN for the scan name.
     * </p>
     * 
     * @return The ARN for the scan name.
     */
    public final String scanNameArn() {
        return scanNameArn;
    }

    /**
     * <p>
     * The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanStateAsString}.
     * </p>
     * 
     * @return The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or
     *         <code>Failed</code>.
     * @see ScanState
     */
    public final ScanState scanState() {
        return ScanState.fromValue(scanState);
    }

    /**
     * <p>
     * The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanStateAsString}.
     * </p>
     * 
     * @return The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or
     *         <code>Failed</code>.
     * @see ScanState
     */
    public final String scanStateAsString() {
        return scanState;
    }

    /**
     * <p>
     * The time the scan was last updated. A scan is updated when it is re-run.
     * </p>
     * 
     * @return The time the scan was last updated. A scan is updated when it is re-run.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(scanNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanSummary)) {
            return false;
        }
        ScanSummary other = (ScanSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(runId(), other.runId())
                && Objects.equals(scanName(), other.scanName()) && Objects.equals(scanNameArn(), other.scanNameArn())
                && Objects.equals(scanStateAsString(), other.scanStateAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanSummary").add("CreatedAt", createdAt()).add("RunId", runId()).add("ScanName", scanName())
                .add("ScanNameArn", scanNameArn()).add("ScanState", scanStateAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "scanNameArn":
            return Optional.ofNullable(clazz.cast(scanNameArn()));
        case "scanState":
            return Optional.ofNullable(clazz.cast(scanStateAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanSummary, T> g) {
        return obj -> g.apply((ScanSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanSummary> {
        /**
         * <p>
         * The time when the scan was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the scan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier for the scan run.
         * </p>
         * 
         * @param runId
         *        The identifier for the scan run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The name of the scan.
         * </p>
         * 
         * @param scanName
         *        The name of the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The ARN for the scan name.
         * </p>
         * 
         * @param scanNameArn
         *        The ARN for the scan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanNameArn(String scanNameArn);

        /**
         * <p>
         * The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or <code>Failed</code>.
         * </p>
         * 
         * @param scanState
         *        The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or
         *        <code>Failed</code>.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder scanState(String scanState);

        /**
         * <p>
         * The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or <code>Failed</code>.
         * </p>
         * 
         * @param scanState
         *        The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or
         *        <code>Failed</code>.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder scanState(ScanState scanState);

        /**
         * <p>
         * The time the scan was last updated. A scan is updated when it is re-run.
         * </p>
         * 
         * @param updatedAt
         *        The time the scan was last updated. A scan is updated when it is re-run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String runId;

        private String scanName;

        private String scanNameArn;

        private String scanState;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanSummary model) {
            createdAt(model.createdAt);
            runId(model.runId);
            scanName(model.scanName);
            scanNameArn(model.scanNameArn);
            scanState(model.scanState);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScanNameArn() {
            return scanNameArn;
        }

        public final void setScanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
        }

        @Override
        public final Builder scanNameArn(String scanNameArn) {
            this.scanNameArn = scanNameArn;
            return this;
        }

        public final String getScanState() {
            return scanState;
        }

        public final void setScanState(String scanState) {
            this.scanState = scanState;
        }

        @Override
        public final Builder scanState(String scanState) {
            this.scanState = scanState;
            return this;
        }

        @Override
        public final Builder scanState(ScanState scanState) {
            this.scanState(scanState == null ? null : scanState.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ScanSummary build() {
            return new ScanSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
