/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsMetricsRequest extends CodeGuruSecurityRequest implements
        ToCopyableBuilder<ListFindingsMetricsRequest.Builder, ListFindingsMetricsRequest> {
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDate").getter(getter(ListFindingsMetricsRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endDate").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFindingsMetricsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsMetricsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(ListFindingsMetricsRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_DATE_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, START_DATE_FIELD));

    private final Instant endDate;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startDate;

    private ListFindingsMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.endDate = builder.endDate;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startDate = builder.startDate;
    }

    /**
     * <p>
     * The end date of the interval which you want to retrieve metrics from. Round to the nearest day.
     * </p>
     * 
     * @return The end date of the interval which you want to retrieve metrics from. Round to the nearest day.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. Use this parameter when paginating results. If
     * additional results exist beyond the number you specify, the <code>nextToken</code> element is returned in the
     * response. Use <code>nextToken</code> in a subsequent request to retrieve additional results. If not specified,
     * returns 1000 results.
     * </p>
     * 
     * @return The maximum number of results to return in the response. Use this parameter when paginating results. If
     *         additional results exist beyond the number you specify, the <code>nextToken</code> element is returned in
     *         the response. Use <code>nextToken</code> in a subsequent request to retrieve additional results. If not
     *         specified, returns 1000 results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request. For subsequent calls, use the <code>nextToken</code> value returned from the previous
     * request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request. For subsequent calls, use the <code>nextToken</code> value returned from
     *         the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The start date of the interval which you want to retrieve metrics from. Rounds to the nearest day.
     * </p>
     * 
     * @return The start date of the interval which you want to retrieve metrics from. Rounds to the nearest day.
     */
    public final Instant startDate() {
        return startDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsMetricsRequest)) {
            return false;
        }
        ListFindingsMetricsRequest other = (ListFindingsMetricsRequest) obj;
        return Objects.equals(endDate(), other.endDate()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(startDate(), other.startDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsMetricsRequest").add("EndDate", endDate()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("StartDate", startDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsMetricsRequest, T> g) {
        return obj -> g.apply((ListFindingsMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFindingsMetricsRequest> {
        /**
         * <p>
         * The end date of the interval which you want to retrieve metrics from. Round to the nearest day.
         * </p>
         * 
         * @param endDate
         *        The end date of the interval which you want to retrieve metrics from. Round to the nearest day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The maximum number of results to return in the response. Use this parameter when paginating results. If
         * additional results exist beyond the number you specify, the <code>nextToken</code> element is returned in the
         * response. Use <code>nextToken</code> in a subsequent request to retrieve additional results. If not
         * specified, returns 1000 results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response. Use this parameter when paginating results.
         *        If additional results exist beyond the number you specify, the <code>nextToken</code> element is
         *        returned in the response. Use <code>nextToken</code> in a subsequent request to retrieve additional
         *        results. If not specified, returns 1000 results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request. For subsequent calls, use the <code>nextToken</code> value returned from the
         * previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request. For subsequent calls, use the <code>nextToken</code> value
         *        returned from the previous request to continue listing results after the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The start date of the interval which you want to retrieve metrics from. Rounds to the nearest day.
         * </p>
         * 
         * @param startDate
         *        The start date of the interval which you want to retrieve metrics from. Rounds to the nearest day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruSecurityRequest.BuilderImpl implements Builder {
        private Instant endDate;

        private Integer maxResults;

        private String nextToken;

        private Instant startDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsMetricsRequest model) {
            super(model);
            endDate(model.endDate);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startDate(model.startDate);
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingsMetricsRequest build() {
            return new ListFindingsMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
