/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFindingsRequest extends CodeGuruSecurityRequest implements
        ToCopyableBuilder<BatchGetFindingsRequest.Builder, BatchGetFindingsRequest> {
    private static final SdkField<List<FindingIdentifier>> FINDING_IDENTIFIERS_FIELD = SdkField
            .<List<FindingIdentifier>> builder(MarshallingType.LIST)
            .memberName("findingIdentifiers")
            .getter(getter(BatchGetFindingsRequest::findingIdentifiers))
            .setter(setter(Builder::findingIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIERS_FIELD));

    private final List<FindingIdentifier> findingIdentifiers;

    private BatchGetFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingIdentifiers = builder.findingIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingIdentifiers() {
        return findingIdentifiers != null && !(findingIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a <code>findingId</code>.
     * You retrieve the <code>findingId</code> when you call <code>GetFindings</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingIdentifiers} method.
     * </p>
     * 
     * @return A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a
     *         <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>.
     */
    public final List<FindingIdentifier> findingIdentifiers() {
        return findingIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIdentifiers() ? findingIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingsRequest)) {
            return false;
        }
        BatchGetFindingsRequest other = (BatchGetFindingsRequest) obj;
        return hasFindingIdentifiers() == other.hasFindingIdentifiers()
                && Objects.equals(findingIdentifiers(), other.findingIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFindingsRequest")
                .add("FindingIdentifiers", hasFindingIdentifiers() ? findingIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingIdentifiers":
            return Optional.ofNullable(clazz.cast(findingIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingsRequest, T> g) {
        return obj -> g.apply((BatchGetFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetFindingsRequest> {
        /**
         * <p>
         * A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a
         * <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>.
         * </p>
         * 
         * @param findingIdentifiers
         *        A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a
         *        <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifiers(Collection<FindingIdentifier> findingIdentifiers);

        /**
         * <p>
         * A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a
         * <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>.
         * </p>
         * 
         * @param findingIdentifiers
         *        A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a
         *        <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIdentifiers(FindingIdentifier... findingIdentifiers);

        /**
         * <p>
         * A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a
         * <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #findingIdentifiers(List<FindingIdentifier>)}.
         * 
         * @param findingIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.FindingIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingIdentifiers(java.util.Collection<FindingIdentifier>)
         */
        Builder findingIdentifiers(Consumer<FindingIdentifier.Builder>... findingIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruSecurityRequest.BuilderImpl implements Builder {
        private List<FindingIdentifier> findingIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingsRequest model) {
            super(model);
            findingIdentifiers(model.findingIdentifiers);
        }

        public final List<FindingIdentifier.Builder> getFindingIdentifiers() {
            List<FindingIdentifier.Builder> result = FindingIdentifiersCopier.copyToBuilder(this.findingIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingIdentifiers(Collection<FindingIdentifier.BuilderImpl> findingIdentifiers) {
            this.findingIdentifiers = FindingIdentifiersCopier.copyFromBuilder(findingIdentifiers);
        }

        @Override
        public final Builder findingIdentifiers(Collection<FindingIdentifier> findingIdentifiers) {
            this.findingIdentifiers = FindingIdentifiersCopier.copy(findingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(FindingIdentifier... findingIdentifiers) {
            findingIdentifiers(Arrays.asList(findingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(Consumer<FindingIdentifier.Builder>... findingIdentifiers) {
            findingIdentifiers(Stream.of(findingIdentifiers).map(c -> FindingIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetFindingsRequest build() {
            return new BatchGetFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
