/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceId
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceId> {
    private static final SdkField<String> CODE_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeArtifactId").getter(ResourceId.getter(ResourceId::codeArtifactId)).setter(ResourceId.setter(Builder::codeArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeArtifactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_ARTIFACT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codeArtifactId;
    private final Type type;

    private ResourceId(BuilderImpl builder) {
        this.codeArtifactId = builder.codeArtifactId;
        this.type = builder.type;
    }

    public final String codeArtifactId() {
        return this.codeArtifactId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeArtifactId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceId)) {
            return false;
        }
        ResourceId other = (ResourceId)obj;
        return Objects.equals(this.codeArtifactId(), other.codeArtifactId());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceId").add("CodeArtifactId", (Object)this.codeArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeArtifactId": {
                return Optional.ofNullable(clazz.cast(this.codeArtifactId()));
            }
        }
        return Optional.empty();
    }

    public static ResourceId fromCodeArtifactId(String codeArtifactId) {
        return (ResourceId)ResourceId.builder().codeArtifactId(codeArtifactId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceId, T> g) {
        return obj -> g.apply((ResourceId)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CODE_ARTIFACT_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String codeArtifactId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceId model) {
            this.codeArtifactId(model.codeArtifactId);
        }

        public final String getCodeArtifactId() {
            return this.codeArtifactId;
        }

        public final void setCodeArtifactId(String codeArtifactId) {
            String oldValue = this.codeArtifactId;
            this.codeArtifactId = codeArtifactId;
            this.handleUnionValueChange(Type.CODE_ARTIFACT_ID, oldValue, this.codeArtifactId);
        }

        @Override
        public final Builder codeArtifactId(String codeArtifactId) {
            String oldValue = this.codeArtifactId;
            this.codeArtifactId = codeArtifactId;
            this.handleUnionValueChange(Type.CODE_ARTIFACT_ID, oldValue, this.codeArtifactId);
            return this;
        }

        public ResourceId build() {
            return new ResourceId(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceId> {
        public Builder codeArtifactId(String var1);
    }
}

