/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityClient;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityClientBuilder;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityServiceClientConfiguration;
import software.amazon.awssdk.services.codegurusecurity.DefaultCodeGuruSecurityBaseClientBuilder;
import software.amazon.awssdk.services.codegurusecurity.DefaultCodeGuruSecurityClient;
import software.amazon.awssdk.services.codegurusecurity.endpoints.CodeGuruSecurityEndpointProvider;

@SdkInternalApi
final class DefaultCodeGuruSecurityClientBuilder
extends DefaultCodeGuruSecurityBaseClientBuilder<CodeGuruSecurityClientBuilder, CodeGuruSecurityClient>
implements CodeGuruSecurityClientBuilder {
    DefaultCodeGuruSecurityClientBuilder() {
    }

    @Override
    public DefaultCodeGuruSecurityClientBuilder endpointProvider(CodeGuruSecurityEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeGuruSecurityClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeGuruSecurityClientBuilder.validateClientOptions(clientConfiguration);
        CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeGuruSecurityClient client = new DefaultCodeGuruSecurityClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeGuruSecurityServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeGuruSecurityServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

