/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RepositoryAssociationState {
    ASSOCIATED("Associated"),
    ASSOCIATING("Associating"),
    FAILED("Failed"),
    DISASSOCIATING("Disassociating"),
    DISASSOCIATED("Disassociated"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RepositoryAssociationState> VALUE_MAP;
    private final String value;

    private RepositoryAssociationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RepositoryAssociationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RepositoryAssociationState> knownValues() {
        EnumSet<RepositoryAssociationState> knownValues = EnumSet.allOf(RepositoryAssociationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RepositoryAssociationState.class, RepositoryAssociationState::toString);
    }
}

