/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigFileState {
    PRESENT("Present"),
    ABSENT("Absent"),
    PRESENT_WITH_ERRORS("PresentWithErrors"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigFileState> VALUE_MAP;
    private final String value;

    private ConfigFileState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigFileState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigFileState> knownValues() {
        EnumSet<ConfigFileState> knownValues = EnumSet.allOf(ConfigFileState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigFileState.class, ConfigFileState::toString);
    }
}

