/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.JobState;
import software.amazon.awssdk.services.codegurureviewer.model.JobStatesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderTypesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryNamesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCodeReviewsRequest
extends CodeGuruReviewerRequest
implements ToCopyableBuilder<Builder, ListCodeReviewsRequest> {
    private static final SdkField<List<String>> PROVIDER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProviderTypes").getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::providerTypesAsStrings)).setter(ListCodeReviewsRequest.setter(Builder::providerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("States").getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::statesAsStrings)).setter(ListCodeReviewsRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("States").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RepositoryNames").getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::repositoryNames)).setter(ListCodeReviewsRequest.setter(Builder::repositoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RepositoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::typeAsString)).setter(ListCodeReviewsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Type").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::maxResults)).setter(ListCodeReviewsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCodeReviewsRequest.getter(ListCodeReviewsRequest::nextToken)).setter(ListCodeReviewsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPES_FIELD, STATES_FIELD, REPOSITORY_NAMES_FIELD, TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCodeReviewsRequest.memberNameToFieldInitializer();
    private final List<String> providerTypes;
    private final List<String> states;
    private final List<String> repositoryNames;
    private final String type;
    private final Integer maxResults;
    private final String nextToken;

    private ListCodeReviewsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypes = builder.providerTypes;
        this.states = builder.states;
        this.repositoryNames = builder.repositoryNames;
        this.type = builder.type;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final List<ProviderType> providerTypes() {
        return ProviderTypesCopier.copyStringToEnum(this.providerTypes);
    }

    public final boolean hasProviderTypes() {
        return this.providerTypes != null && !(this.providerTypes instanceof SdkAutoConstructList);
    }

    public final List<String> providerTypesAsStrings() {
        return this.providerTypes;
    }

    public final List<JobState> states() {
        return JobStatesCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final boolean hasRepositoryNames() {
        return this.repositoryNames != null && !(this.repositoryNames instanceof SdkAutoConstructList);
    }

    public final List<String> repositoryNames() {
        return this.repositoryNames;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderTypes() ? this.providerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryNames() ? this.repositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeReviewsRequest)) {
            return false;
        }
        ListCodeReviewsRequest other = (ListCodeReviewsRequest)((Object)obj);
        return this.hasProviderTypes() == other.hasProviderTypes() && Objects.equals(this.providerTypesAsStrings(), other.providerTypesAsStrings()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && this.hasRepositoryNames() == other.hasRepositoryNames() && Objects.equals(this.repositoryNames(), other.repositoryNames()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCodeReviewsRequest").add("ProviderTypes", this.hasProviderTypes() ? this.providerTypesAsStrings() : null).add("States", this.hasStates() ? this.statesAsStrings() : null).add("RepositoryNames", this.hasRepositoryNames() ? this.repositoryNames() : null).add("Type", (Object)this.typeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderTypes": {
                return Optional.ofNullable(clazz.cast(this.providerTypesAsStrings()));
            }
            case "States": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "RepositoryNames": {
                return Optional.ofNullable(clazz.cast(this.repositoryNames()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProviderTypes", PROVIDER_TYPES_FIELD);
        map.put("States", STATES_FIELD);
        map.put("RepositoryNames", REPOSITORY_NAMES_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeReviewsRequest, T> g) {
        return obj -> g.apply((ListCodeReviewsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerRequest.BuilderImpl
    implements Builder {
        private List<String> providerTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeReviewsRequest model) {
            super(model);
            this.providerTypesWithStrings(model.providerTypes);
            this.statesWithStrings(model.states);
            this.repositoryNames(model.repositoryNames);
            this.type(model.type);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProviderTypes() {
            if (this.providerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.providerTypes;
        }

        public final void setProviderTypes(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
        }

        @Override
        public final Builder providerTypesWithStrings(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypesWithStrings(String ... providerTypes) {
            this.providerTypesWithStrings(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        public final Builder providerTypes(Collection<ProviderType> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copyEnumToString(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(ProviderType ... providerTypes) {
            this.providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        public final void setStates(Collection<String> states) {
            this.states = JobStatesCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = JobStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<JobState> states) {
            this.states = JobStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(JobState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final Collection<String> getRepositoryNames() {
            if (this.repositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.repositoryNames;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNamesCopier.copy(repositoryNames);
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNamesCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String ... repositoryNames) {
            this.repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCodeReviewsRequest build() {
            return new ListCodeReviewsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCodeReviewsRequest> {
        public Builder providerTypesWithStrings(Collection<String> var1);

        public Builder providerTypesWithStrings(String ... var1);

        public Builder providerTypes(Collection<ProviderType> var1);

        public Builder providerTypes(ProviderType ... var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<JobState> var1);

        public Builder states(JobState ... var1);

        public Builder repositoryNames(Collection<String> var1);

        public Builder repositoryNames(String ... var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

