/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerResponse;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummariesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoryAssociationsResponse
extends CodeGuruReviewerResponse
implements ToCopyableBuilder<Builder, ListRepositoryAssociationsResponse> {
    private static final SdkField<List<RepositoryAssociationSummary>> REPOSITORY_ASSOCIATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RepositoryAssociationSummaries").getter(ListRepositoryAssociationsResponse.getter(ListRepositoryAssociationsResponse::repositoryAssociationSummaries)).setter(ListRepositoryAssociationsResponse.setter(Builder::repositoryAssociationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAssociationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRepositoryAssociationsResponse.getter(ListRepositoryAssociationsResponse::nextToken)).setter(ListRepositoryAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RepositoryAssociationSummary> repositoryAssociationSummaries;
    private final String nextToken;

    private ListRepositoryAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryAssociationSummaries = builder.repositoryAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRepositoryAssociationSummaries() {
        return this.repositoryAssociationSummaries != null && !(this.repositoryAssociationSummaries instanceof SdkAutoConstructList);
    }

    public final List<RepositoryAssociationSummary> repositoryAssociationSummaries() {
        return this.repositoryAssociationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryAssociationSummaries() ? this.repositoryAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryAssociationsResponse)) {
            return false;
        }
        ListRepositoryAssociationsResponse other = (ListRepositoryAssociationsResponse)((Object)obj);
        return this.hasRepositoryAssociationSummaries() == other.hasRepositoryAssociationSummaries() && Objects.equals(this.repositoryAssociationSummaries(), other.repositoryAssociationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRepositoryAssociationsResponse").add("RepositoryAssociationSummaries", this.hasRepositoryAssociationSummaries() ? this.repositoryAssociationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryAssociationSummaries": {
                return Optional.ofNullable(clazz.cast(this.repositoryAssociationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoryAssociationsResponse, T> g) {
        return obj -> g.apply((ListRepositoryAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerResponse.BuilderImpl
    implements Builder {
        private List<RepositoryAssociationSummary> repositoryAssociationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoryAssociationsResponse model) {
            super(model);
            this.repositoryAssociationSummaries(model.repositoryAssociationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<RepositoryAssociationSummary.Builder> getRepositoryAssociationSummaries() {
            List<RepositoryAssociationSummary.Builder> result = RepositoryAssociationSummariesCopier.copyToBuilder(this.repositoryAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryAssociationSummaries(Collection<RepositoryAssociationSummary.BuilderImpl> repositoryAssociationSummaries) {
            this.repositoryAssociationSummaries = RepositoryAssociationSummariesCopier.copyFromBuilder(repositoryAssociationSummaries);
        }

        @Override
        public final Builder repositoryAssociationSummaries(Collection<RepositoryAssociationSummary> repositoryAssociationSummaries) {
            this.repositoryAssociationSummaries = RepositoryAssociationSummariesCopier.copy(repositoryAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryAssociationSummaries(RepositoryAssociationSummary ... repositoryAssociationSummaries) {
            this.repositoryAssociationSummaries(Arrays.asList(repositoryAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryAssociationSummaries(Consumer<RepositoryAssociationSummary.Builder> ... repositoryAssociationSummaries) {
            this.repositoryAssociationSummaries(Stream.of(repositoryAssociationSummaries).map(c -> (RepositoryAssociationSummary)((RepositoryAssociationSummary.Builder)RepositoryAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRepositoryAssociationsResponse build() {
            return new ListRepositoryAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoryAssociationsResponse> {
        public Builder repositoryAssociationSummaries(Collection<RepositoryAssociationSummary> var1);

        public Builder repositoryAssociationSummaries(RepositoryAssociationSummary ... var1);

        public Builder repositoryAssociationSummaries(Consumer<RepositoryAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

