/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StopStatus {
    PENDING("Pending"),
    SUCCEEDED("Succeeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StopStatus> VALUE_MAP;
    private final String value;

    private StopStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StopStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StopStatus> knownValues() {
        EnumSet<StopStatus> knownValues = EnumSet.allOf(StopStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StopStatus.class, StopStatus::toString);
    }
}

