/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfigInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfigInfo> {
    private static final SdkField<String> DEPLOYMENT_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentConfigId").getter(DeploymentConfigInfo.getter(DeploymentConfigInfo::deploymentConfigId)).setter(DeploymentConfigInfo.setter(Builder::deploymentConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentConfigName").getter(DeploymentConfigInfo.getter(DeploymentConfigInfo::deploymentConfigName)).setter(DeploymentConfigInfo.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<MinimumHealthyHosts> MINIMUM_HEALTHY_HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("minimumHealthyHosts").getter(DeploymentConfigInfo.getter(DeploymentConfigInfo::minimumHealthyHosts)).setter(DeploymentConfigInfo.setter(Builder::minimumHealthyHosts)).constructor(MinimumHealthyHosts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumHealthyHosts").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(DeploymentConfigInfo.getter(DeploymentConfigInfo::createTime)).setter(DeploymentConfigInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computePlatform").getter(DeploymentConfigInfo.getter(DeploymentConfigInfo::computePlatformAsString)).setter(DeploymentConfigInfo.setter(Builder::computePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final SdkField<TrafficRoutingConfig> TRAFFIC_ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trafficRoutingConfig").getter(DeploymentConfigInfo.getter(DeploymentConfigInfo::trafficRoutingConfig)).setter(DeploymentConfigInfo.setter(Builder::trafficRoutingConfig)).constructor(TrafficRoutingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficRoutingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_ID_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, MINIMUM_HEALTHY_HOSTS_FIELD, CREATE_TIME_FIELD, COMPUTE_PLATFORM_FIELD, TRAFFIC_ROUTING_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentConfigId;
    private final String deploymentConfigName;
    private final MinimumHealthyHosts minimumHealthyHosts;
    private final Instant createTime;
    private final String computePlatform;
    private final TrafficRoutingConfig trafficRoutingConfig;

    private DeploymentConfigInfo(BuilderImpl builder) {
        this.deploymentConfigId = builder.deploymentConfigId;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.createTime = builder.createTime;
        this.computePlatform = builder.computePlatform;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
    }

    public final String deploymentConfigId() {
        return this.deploymentConfigId;
    }

    public final String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public final MinimumHealthyHosts minimumHealthyHosts() {
        return this.minimumHealthyHosts;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public final String computePlatformAsString() {
        return this.computePlatform;
    }

    public final TrafficRoutingConfig trafficRoutingConfig() {
        return this.trafficRoutingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficRoutingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfigInfo)) {
            return false;
        }
        DeploymentConfigInfo other = (DeploymentConfigInfo)obj;
        return Objects.equals(this.deploymentConfigId(), other.deploymentConfigId()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.minimumHealthyHosts(), other.minimumHealthyHosts()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString()) && Objects.equals(this.trafficRoutingConfig(), other.trafficRoutingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentConfigInfo").add("DeploymentConfigId", (Object)this.deploymentConfigId()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("MinimumHealthyHosts", (Object)this.minimumHealthyHosts()).add("CreateTime", (Object)this.createTime()).add("ComputePlatform", (Object)this.computePlatformAsString()).add("TrafficRoutingConfig", (Object)this.trafficRoutingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigId": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigId()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "minimumHealthyHosts": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyHosts()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
            case "trafficRoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.trafficRoutingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfigInfo, T> g) {
        return obj -> g.apply((DeploymentConfigInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentConfigId;
        private String deploymentConfigName;
        private MinimumHealthyHosts minimumHealthyHosts;
        private Instant createTime;
        private String computePlatform;
        private TrafficRoutingConfig trafficRoutingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfigInfo model) {
            this.deploymentConfigId(model.deploymentConfigId);
            this.deploymentConfigName(model.deploymentConfigName);
            this.minimumHealthyHosts(model.minimumHealthyHosts);
            this.createTime(model.createTime);
            this.computePlatform(model.computePlatform);
            this.trafficRoutingConfig(model.trafficRoutingConfig);
        }

        public final String getDeploymentConfigId() {
            return this.deploymentConfigId;
        }

        public final void setDeploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
        }

        @Override
        public final Builder deploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
            return this;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return this.minimumHealthyHosts != null ? this.minimumHealthyHosts.toBuilder() : null;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return this.trafficRoutingConfig != null ? this.trafficRoutingConfig.toBuilder() : null;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public DeploymentConfigInfo build() {
            return new DeploymentConfigInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfigInfo> {
        public Builder deploymentConfigId(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder minimumHealthyHosts(MinimumHealthyHosts var1);

        default public Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return this.minimumHealthyHosts((MinimumHealthyHosts)((MinimumHealthyHosts.Builder)MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts)).build());
        }

        public Builder createTime(Instant var1);

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder trafficRoutingConfig(TrafficRoutingConfig var1);

        default public Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return this.trafficRoutingConfig((TrafficRoutingConfig)((TrafficRoutingConfig.Builder)TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig)).build());
        }
    }
}

