/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A revision for an AWS Lambda deployment that is a YAML-formatted or JSON-formatted string. For AWS Lambda
 * deployments, the revision is the same as the AppSpec file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RawString implements SdkPojo, Serializable, ToCopyableBuilder<RawString.Builder, RawString> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RawString::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RawString::sha256)).setter(setter(Builder::sha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, SHA256_FIELD));

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String sha256;

    private RawString(BuilderImpl builder) {
        this.content = builder.content;
        this.sha256 = builder.sha256;
    }

    /**
     * <p>
     * The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to
     * update and optional Lambda functions that validate deployment lifecycle events.
     * </p>
     * 
     * @return The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function
     *         to update and optional Lambda functions that validate deployment lifecycle events.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * The SHA256 hash value of the revision content.
     * </p>
     * 
     * @return The SHA256 hash value of the revision content.
     */
    public String sha256() {
        return sha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(sha256());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawString)) {
            return false;
        }
        RawString other = (RawString) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(sha256(), other.sha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RawString").add("Content", content()).add("Sha256", sha256()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "sha256":
            return Optional.ofNullable(clazz.cast(sha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RawString, T> g) {
        return obj -> g.apply((RawString) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RawString> {
        /**
         * <p>
         * The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda function to
         * update and optional Lambda functions that validate deployment lifecycle events.
         * </p>
         * 
         * @param content
         *        The YAML-formatted or JSON-formatted revision string. It includes information about which Lambda
         *        function to update and optional Lambda functions that validate deployment lifecycle events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The SHA256 hash value of the revision content.
         * </p>
         * 
         * @param sha256
         *        The SHA256 hash value of the revision content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha256(String sha256);
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(RawString model) {
            content(model.content);
            sha256(model.sha256);
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getSha256() {
            return sha256;
        }

        @Override
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @Override
        public RawString build() {
            return new RawString(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
