/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentTargetsRequest extends CodeDeployRequest implements
        ToCopyableBuilder<ListDeploymentTargetsRequest.Builder, ListDeploymentTargetsRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeploymentTargetsRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeploymentTargetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Map<String, List<String>>> TARGET_FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(ListDeploymentTargetsRequest::targetFiltersAsStrings))
            .setter(setter(Builder::targetFiltersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFilters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            NEXT_TOKEN_FIELD, TARGET_FILTERS_FIELD));

    private final String deploymentId;

    private final String nextToken;

    private final Map<String, List<String>> targetFilters;

    private ListDeploymentTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.nextToken = builder.nextToken;
        this.targetFilters = builder.targetFilters;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to return
     * the next set of deployment targets in the list.
     * </p>
     * 
     * @return A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to
     *         return the next set of deployment targets in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A key used to filter the returned targets. The two valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
     * <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>,
     * or <code>Unknown</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or
     * <code>Green</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key used to filter the returned targets. The two valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
     *         <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>,
     *         <code>Succeeded</code>, or <code>Unknown</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be
     *         <code>Blue</code> or <code>Green</code>.
     *         </p>
     *         </li>
     */
    public Map<TargetFilterName, List<String>> targetFilters() {
        return TargetFiltersCopier.copyStringToEnum(targetFilters);
    }

    /**
     * Returns true if the TargetFilters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargetFilters() {
        return targetFilters != null && !(targetFilters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key used to filter the returned targets. The two valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
     * <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>, <code>Succeeded</code>,
     * or <code>Unknown</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code> or
     * <code>Green</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key used to filter the returned targets. The two valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
     *         <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>,
     *         <code>Succeeded</code>, or <code>Unknown</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be
     *         <code>Blue</code> or <code>Green</code>.
     *         </p>
     *         </li>
     */
    public Map<String, List<String>> targetFiltersAsStrings() {
        return targetFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(targetFiltersAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentTargetsRequest)) {
            return false;
        }
        ListDeploymentTargetsRequest other = (ListDeploymentTargetsRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(targetFiltersAsStrings(), other.targetFiltersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeploymentTargetsRequest").add("DeploymentId", deploymentId()).add("NextToken", nextToken())
                .add("TargetFilters", targetFiltersAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "targetFilters":
            return Optional.ofNullable(clazz.cast(targetFiltersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentTargetsRequest, T> g) {
        return obj -> g.apply((ListDeploymentTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDeploymentTargetsRequest> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used to
         * return the next set of deployment targets in the list.
         * </p>
         * 
         * @param nextToken
         *        A token identifier returned from the previous <code>ListDeploymentTargets</code> call. It can be used
         *        to return the next set of deployment targets in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A key used to filter the returned targets. The two valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
         * <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>,
         * <code>Succeeded</code>, or <code>Unknown</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code>
         * or <code>Green</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetFilters
         *        A key used to filter the returned targets. The two valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
         *        <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>,
         *        <code>Succeeded</code>, or <code>Unknown</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be
         *        <code>Blue</code> or <code>Green</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFiltersWithStrings(Map<String, ? extends Collection<String>> targetFilters);

        /**
         * <p>
         * A key used to filter the returned targets. The two valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
         * <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>,
         * <code>Succeeded</code>, or <code>Unknown</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be <code>Blue</code>
         * or <code>Green</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetFilters
         *        A key used to filter the returned targets. The two valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TargetStatus</code> - A <code>TargetStatus</code> filter string can be <code>Failed</code>,
         *        <code>InProgress</code>, <code>Pending</code>, <code>Ready</code>, <code>Skipped</code>,
         *        <code>Succeeded</code>, or <code>Unknown</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ServerInstanceLabel</code> - A <code>ServerInstanceLabel</code> filter string can be
         *        <code>Blue</code> or <code>Green</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFilters(Map<TargetFilterName, ? extends Collection<String>> targetFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private String nextToken;

        private Map<String, List<String>> targetFilters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentTargetsRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            nextToken(model.nextToken);
            targetFiltersWithStrings(model.targetFilters);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Map<String, ? extends Collection<String>> getTargetFiltersAsStrings() {
            return targetFilters;
        }

        @Override
        public final Builder targetFiltersWithStrings(Map<String, ? extends Collection<String>> targetFilters) {
            this.targetFilters = TargetFiltersCopier.copy(targetFilters);
            return this;
        }

        @Override
        public final Builder targetFilters(Map<TargetFilterName, ? extends Collection<String>> targetFilters) {
            this.targetFilters = TargetFiltersCopier.copyEnumToString(targetFilters);
            return this;
        }

        public final void setTargetFiltersWithStrings(Map<String, ? extends Collection<String>> targetFilters) {
            this.targetFilters = TargetFiltersCopier.copy(targetFilters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeploymentTargetsRequest build() {
            return new ListDeploymentTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
