/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.waiters;

import javax.annotation.Generated;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.*;
import software.amazon.awssdk.waiters.*;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CodeDeployClientWaiters {

    /**
     * Represents the service client
     */
    private final CodeDeployClient client;

    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    /**
     * Constructs a new CodeDeployClientWaiters with the given client
     * 
     * @param client
     *        Service client
     */
    @SdkInternalApi
    public CodeDeployClientWaiters(CodeDeployClient client) {
        this.client = client;
    }

    /**
     * Builds a DeploymentSuccessful waiter by using custom parameters waiterParameters and other parameters defined in
     * the waiters specification, and then polls until it determines whether the resource entered the desired state or
     * not, where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<GetDeploymentRequest> deploymentSuccessful() {

        return new WaiterBuilder<GetDeploymentRequest, GetDeploymentResponse>()
                .withSdkFunction(new GetDeploymentFunction(client))
                .withAcceptors(new DeploymentSuccessful.IsSucceededMatcher(), new DeploymentSuccessful.IsFailedMatcher(),
                        new DeploymentSuccessful.IsStoppedMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(120), new FixedDelayStrategy(15)))
                .withExecutorService(executorService).build();
    }

}
