/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.codedeploy.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeregisterOnPremisesInstanceResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeregisterOnPremisesInstanceResponseUnmarshaller implements
        Unmarshaller<DeregisterOnPremisesInstanceResponse, JsonUnmarshallerContext> {

    public DeregisterOnPremisesInstanceResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeregisterOnPremisesInstanceResponse.Builder deregisterOnPremisesInstanceResponseBuilder = DeregisterOnPremisesInstanceResponse
                .builder();

        return deregisterOnPremisesInstanceResponseBuilder.build();
    }

    private static DeregisterOnPremisesInstanceResponseUnmarshaller INSTANCE;

    public static DeregisterOnPremisesInstanceResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DeregisterOnPremisesInstanceResponseUnmarshaller();
        return INSTANCE;
    }
}