/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.codedeploy.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeploymentInfo JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeploymentInfoUnmarshaller implements Unmarshaller<DeploymentInfo, JsonUnmarshallerContext> {

    public DeploymentInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeploymentInfo.Builder deploymentInfoBuilder = DeploymentInfo.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("applicationName", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.applicationName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deploymentGroupName", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.deploymentGroupName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deploymentConfigName", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.deploymentConfigName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deploymentId", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.deploymentId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("previousRevision", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.previousRevision(RevisionLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("revision", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.revision(RevisionLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("errorInformation", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.errorInformation(ErrorInformationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("createTime", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.createTime(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.startTime(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("completeTime", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.completeTime(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("deploymentOverview", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.deploymentOverview(DeploymentOverviewUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creator", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.creator(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ignoreApplicationStopFailures", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.ignoreApplicationStopFailures(context.getUnmarshaller(Boolean.class)
                            .unmarshall(context));
                }
                if (context.testExpression("autoRollbackConfiguration", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.autoRollbackConfiguration(AutoRollbackConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("updateOutdatedInstancesOnly", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.updateOutdatedInstancesOnly(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("rollbackInfo", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.rollbackInfo(RollbackInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("deploymentStyle", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.deploymentStyle(DeploymentStyleUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("targetInstances", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.targetInstances(TargetInstancesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("instanceTerminationWaitTimeStarted", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.instanceTerminationWaitTimeStarted(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
                if (context.testExpression("blueGreenDeploymentConfiguration", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.blueGreenDeploymentConfiguration(BlueGreenDeploymentConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("loadBalancerInfo", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.loadBalancerInfo(LoadBalancerInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("additionalDeploymentStatusInfo", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.additionalDeploymentStatusInfo(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("fileExistsBehavior", targetDepth)) {
                    context.nextToken();
                    deploymentInfoBuilder.fileExistsBehavior(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deploymentInfoBuilder.build();
    }

    private static DeploymentInfoUnmarshaller INSTANCE;

    public static DeploymentInfoUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DeploymentInfoUnmarshaller();
        return INSTANCE;
    }
}