/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.codedeploy.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * DeploymentInfoMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DeploymentInfoMarshaller {

    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationName").build();
    private static final MarshallingInfo<String> DEPLOYMENTGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentGroupName").build();
    private static final MarshallingInfo<String> DEPLOYMENTCONFIGNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentConfigName").build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").build();
    private static final MarshallingInfo<StructuredPojo> PREVIOUSREVISION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("previousRevision").build();
    private static final MarshallingInfo<StructuredPojo> REVISION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<StructuredPojo> ERRORINFORMATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("errorInformation").build();
    private static final MarshallingInfo<java.util.Date> CREATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").build();
    private static final MarshallingInfo<java.util.Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<java.util.Date> COMPLETETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completeTime").build();
    private static final MarshallingInfo<StructuredPojo> DEPLOYMENTOVERVIEW_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("deploymentOverview").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> CREATOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creator").build();
    private static final MarshallingInfo<Boolean> IGNOREAPPLICATIONSTOPFAILURES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ignoreApplicationStopFailures").build();
    private static final MarshallingInfo<StructuredPojo> AUTOROLLBACKCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("autoRollbackConfiguration").build();
    private static final MarshallingInfo<Boolean> UPDATEOUTDATEDINSTANCESONLY_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("updateOutdatedInstancesOnly").build();
    private static final MarshallingInfo<StructuredPojo> ROLLBACKINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rollbackInfo")
            .build();
    private static final MarshallingInfo<StructuredPojo> DEPLOYMENTSTYLE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("deploymentStyle").build();
    private static final MarshallingInfo<StructuredPojo> TARGETINSTANCES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("targetInstances").build();
    private static final MarshallingInfo<Boolean> INSTANCETERMINATIONWAITTIMESTARTED_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("instanceTerminationWaitTimeStarted").build();
    private static final MarshallingInfo<StructuredPojo> BLUEGREENDEPLOYMENTCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("blueGreenDeploymentConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> LOADBALANCERINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("loadBalancerInfo").build();
    private static final MarshallingInfo<String> ADDITIONALDEPLOYMENTSTATUSINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("additionalDeploymentStatusInfo").build();
    private static final MarshallingInfo<String> FILEEXISTSBEHAVIOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileExistsBehavior").build();

    private static final DeploymentInfoMarshaller instance = new DeploymentInfoMarshaller();

    public static DeploymentInfoMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DeploymentInfo deploymentInfo, ProtocolMarshaller protocolMarshaller) {

        if (deploymentInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(deploymentInfo.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall(deploymentInfo.deploymentGroupName(), DEPLOYMENTGROUPNAME_BINDING);
            protocolMarshaller.marshall(deploymentInfo.deploymentConfigName(), DEPLOYMENTCONFIGNAME_BINDING);
            protocolMarshaller.marshall(deploymentInfo.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall(deploymentInfo.previousRevision(), PREVIOUSREVISION_BINDING);
            protocolMarshaller.marshall(deploymentInfo.revision(), REVISION_BINDING);
            protocolMarshaller.marshall(deploymentInfo.status(), STATUS_BINDING);
            protocolMarshaller.marshall(deploymentInfo.errorInformation(), ERRORINFORMATION_BINDING);
            protocolMarshaller.marshall(deploymentInfo.createTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall(deploymentInfo.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(deploymentInfo.completeTime(), COMPLETETIME_BINDING);
            protocolMarshaller.marshall(deploymentInfo.deploymentOverview(), DEPLOYMENTOVERVIEW_BINDING);
            protocolMarshaller.marshall(deploymentInfo.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(deploymentInfo.creator(), CREATOR_BINDING);
            protocolMarshaller.marshall(deploymentInfo.ignoreApplicationStopFailures(), IGNOREAPPLICATIONSTOPFAILURES_BINDING);
            protocolMarshaller.marshall(deploymentInfo.autoRollbackConfiguration(), AUTOROLLBACKCONFIGURATION_BINDING);
            protocolMarshaller.marshall(deploymentInfo.updateOutdatedInstancesOnly(), UPDATEOUTDATEDINSTANCESONLY_BINDING);
            protocolMarshaller.marshall(deploymentInfo.rollbackInfo(), ROLLBACKINFO_BINDING);
            protocolMarshaller.marshall(deploymentInfo.deploymentStyle(), DEPLOYMENTSTYLE_BINDING);
            protocolMarshaller.marshall(deploymentInfo.targetInstances(), TARGETINSTANCES_BINDING);
            protocolMarshaller.marshall(deploymentInfo.instanceTerminationWaitTimeStarted(),
                    INSTANCETERMINATIONWAITTIMESTARTED_BINDING);
            protocolMarshaller.marshall(deploymentInfo.blueGreenDeploymentConfiguration(),
                    BLUEGREENDEPLOYMENTCONFIGURATION_BINDING);
            protocolMarshaller.marshall(deploymentInfo.loadBalancerInfo(), LOADBALANCERINFO_BINDING);
            protocolMarshaller.marshall(deploymentInfo.additionalDeploymentStatusInfo(), ADDITIONALDEPLOYMENTSTATUSINFO_BINDING);
            protocolMarshaller.marshall(deploymentInfo.fileExistsBehavior(), FILEEXISTSBEHAVIOR_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
