/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.codedeploy.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeploymentGroupInfo JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeploymentGroupInfoUnmarshaller implements Unmarshaller<DeploymentGroupInfo, JsonUnmarshallerContext> {

    public DeploymentGroupInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeploymentGroupInfo.Builder deploymentGroupInfoBuilder = DeploymentGroupInfo.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("applicationName", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.applicationName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deploymentGroupId", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.deploymentGroupId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deploymentGroupName", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.deploymentGroupName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deploymentConfigName", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.deploymentConfigName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ec2TagFilters", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.ec2TagFilters(new ListUnmarshaller<EC2TagFilter>(EC2TagFilterUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("onPremisesInstanceTagFilters", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.onPremisesInstanceTagFilters(new ListUnmarshaller<TagFilter>(TagFilterUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("autoScalingGroups", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.autoScalingGroups(new ListUnmarshaller<AutoScalingGroup>(
                            AutoScalingGroupUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("serviceRoleArn", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.serviceRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("targetRevision", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.targetRevision(RevisionLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("triggerConfigurations", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.triggerConfigurations(new ListUnmarshaller<TriggerConfig>(
                            TriggerConfigUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("alarmConfiguration", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.alarmConfiguration(AlarmConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("autoRollbackConfiguration", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.autoRollbackConfiguration(AutoRollbackConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("deploymentStyle", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.deploymentStyle(DeploymentStyleUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("blueGreenDeploymentConfiguration", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.blueGreenDeploymentConfiguration(BlueGreenDeploymentConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("loadBalancerInfo", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.loadBalancerInfo(LoadBalancerInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("lastSuccessfulDeployment", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.lastSuccessfulDeployment(LastDeploymentInfoUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("lastAttemptedDeployment", targetDepth)) {
                    context.nextToken();
                    deploymentGroupInfoBuilder.lastAttemptedDeployment(LastDeploymentInfoUnmarshaller.getInstance().unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deploymentGroupInfoBuilder.build();
    }

    private static DeploymentGroupInfoUnmarshaller INSTANCE;

    public static DeploymentGroupInfoUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DeploymentGroupInfoUnmarshaller();
        return INSTANCE;
    }
}