/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.codedeploy.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * BlueGreenDeploymentConfigurationMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class BlueGreenDeploymentConfigurationMarshaller {

    private static final MarshallingInfo<StructuredPojo> TERMINATEBLUEINSTANCESONDEPLOYMENTSUCCESS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("terminateBlueInstancesOnDeploymentSuccess").build();
    private static final MarshallingInfo<StructuredPojo> DEPLOYMENTREADYOPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("deploymentReadyOption").build();
    private static final MarshallingInfo<StructuredPojo> GREENFLEETPROVISIONINGOPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("greenFleetProvisioningOption").build();

    private static final BlueGreenDeploymentConfigurationMarshaller instance = new BlueGreenDeploymentConfigurationMarshaller();

    public static BlueGreenDeploymentConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (blueGreenDeploymentConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(blueGreenDeploymentConfiguration.terminateBlueInstancesOnDeploymentSuccess(),
                    TERMINATEBLUEINSTANCESONDEPLOYMENTSUCCESS_BINDING);
            protocolMarshaller.marshall(blueGreenDeploymentConfiguration.deploymentReadyOption(), DEPLOYMENTREADYOPTION_BINDING);
            protocolMarshaller.marshall(blueGreenDeploymentConfiguration.greenFleetProvisioningOption(),
                    GREENFLEETPROVISIONINGOPTION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
