/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an UpdateDeploymentGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDeploymentGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDeploymentGroupRequest.Builder, UpdateDeploymentGroupRequest> {
    private final String applicationName;

    private final String currentDeploymentGroupName;

    private final String newDeploymentGroupName;

    private final String deploymentConfigName;

    private final List<EC2TagFilter> ec2TagFilters;

    private final List<TagFilter> onPremisesInstanceTagFilters;

    private final List<String> autoScalingGroups;

    private final String serviceRoleArn;

    private final List<TriggerConfig> triggerConfigurations;

    private final AlarmConfiguration alarmConfiguration;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final DeploymentStyle deploymentStyle;

    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

    private final LoadBalancerInfo loadBalancerInfo;

    private UpdateDeploymentGroupRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentDeploymentGroupName = builder.currentDeploymentGroupName;
        this.newDeploymentGroupName = builder.newDeploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
    }

    /**
     * <p>
     * The application name corresponding to the deployment group to update.
     * </p>
     * 
     * @return The application name corresponding to the deployment group to update.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current name of the deployment group.
     * </p>
     * 
     * @return The current name of the deployment group.
     */
    public String currentDeploymentGroupName() {
        return currentDeploymentGroupName;
    }

    /**
     * <p>
     * The new name of the deployment group, if you want to change it.
     * </p>
     * 
     * @return The new name of the deployment group, if you want to change it.
     */
    public String newDeploymentGroupName() {
        return newDeploymentGroupName;
    }

    /**
     * <p>
     * The replacement deployment configuration name to use, if you want to change it.
     * </p>
     * 
     * @return The replacement deployment configuration name to use, if you want to change it.
     */
    public String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags,
     * enter their names. To remove tags, do not enter any tag names.
     * </p>
     * 
     * @return The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
     *         existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public List<EC2TagFilter> ec2TagFilters() {
        return ec2TagFilters;
    }

    /**
     * <p>
     * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
     * existing tags, enter their names. To remove tags, do not enter any tag names.
     * </p>
     * 
     * @return The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep
     *         the existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public List<TagFilter> onPremisesInstanceTagFilters() {
        return onPremisesInstanceTagFilters;
    }

    /**
     * <p>
     * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them.
     * To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling
     * group names.
     * </p>
     * 
     * @return The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
     *         them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any
     *         Auto Scaling group names.
     */
    public List<String> autoScalingGroups() {
        return autoScalingGroups;
    }

    /**
     * <p>
     * A replacement ARN for the service role, if you want to change it.
     * </p>
     * 
     * @return A replacement ARN for the service role, if you want to change it.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Information about triggers to change when the deployment group is updated. For examples, see <a
     * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an AWS
     * CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
     * </p>
     * 
     * @return Information about triggers to change when the deployment group is updated. For examples, see <a
     *         href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in
     *         an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
     */
    public List<TriggerConfig> triggerConfigurations() {
        return triggerConfigurations;
    }

    /**
     * <p>
     * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     * </p>
     * 
     * @return Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     */
    public AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * <p>
     * Information for an automatic rollback configuration that is added or changed when a deployment group is updated.
     * </p>
     * 
     * @return Information for an automatic rollback configuration that is added or changed when a deployment group is
     *         updated.
     */
    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
     * deployment traffic behind a load balancer.
     * </p>
     * 
     * @return Information about the type of deployment, either in-place or blue/green, you want to run and whether to
     *         route deployment traffic behind a load balancer.
     */
    public DeploymentStyle deploymentStyle() {
        return deploymentStyle;
    }

    /**
     * <p>
     * Information about blue/green deployment options for a deployment group.
     * </p>
     * 
     * @return Information about blue/green deployment options for a deployment group.
     */
    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return blueGreenDeploymentConfiguration;
    }

    /**
     * <p>
     * Information about the load balancer used in a deployment.
     * </p>
     * 
     * @return Information about the load balancer used in a deployment.
     */
    public LoadBalancerInfo loadBalancerInfo() {
        return loadBalancerInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((currentDeploymentGroupName() == null) ? 0 : currentDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + ((newDeploymentGroupName() == null) ? 0 : newDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + ((deploymentConfigName() == null) ? 0 : deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + ((ec2TagFilters() == null) ? 0 : ec2TagFilters().hashCode());
        hashCode = 31 * hashCode + ((onPremisesInstanceTagFilters() == null) ? 0 : onPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroups() == null) ? 0 : autoScalingGroups().hashCode());
        hashCode = 31 * hashCode + ((serviceRoleArn() == null) ? 0 : serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + ((triggerConfigurations() == null) ? 0 : triggerConfigurations().hashCode());
        hashCode = 31 * hashCode + ((alarmConfiguration() == null) ? 0 : alarmConfiguration().hashCode());
        hashCode = 31 * hashCode + ((autoRollbackConfiguration() == null) ? 0 : autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + ((deploymentStyle() == null) ? 0 : deploymentStyle().hashCode());
        hashCode = 31 * hashCode
                + ((blueGreenDeploymentConfiguration() == null) ? 0 : blueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + ((loadBalancerInfo() == null) ? 0 : loadBalancerInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentDeploymentGroupName() == null ^ this.currentDeploymentGroupName() == null) {
            return false;
        }
        if (other.currentDeploymentGroupName() != null
                && !other.currentDeploymentGroupName().equals(this.currentDeploymentGroupName())) {
            return false;
        }
        if (other.newDeploymentGroupName() == null ^ this.newDeploymentGroupName() == null) {
            return false;
        }
        if (other.newDeploymentGroupName() != null && !other.newDeploymentGroupName().equals(this.newDeploymentGroupName())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.ec2TagFilters() == null ^ this.ec2TagFilters() == null) {
            return false;
        }
        if (other.ec2TagFilters() != null && !other.ec2TagFilters().equals(this.ec2TagFilters())) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() == null ^ this.onPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() != null
                && !other.onPremisesInstanceTagFilters().equals(this.onPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.triggerConfigurations() == null ^ this.triggerConfigurations() == null) {
            return false;
        }
        if (other.triggerConfigurations() != null && !other.triggerConfigurations().equals(this.triggerConfigurations())) {
            return false;
        }
        if (other.alarmConfiguration() == null ^ this.alarmConfiguration() == null) {
            return false;
        }
        if (other.alarmConfiguration() != null && !other.alarmConfiguration().equals(this.alarmConfiguration())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null
                && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.deploymentStyle() == null ^ this.deploymentStyle() == null) {
            return false;
        }
        if (other.deploymentStyle() != null && !other.deploymentStyle().equals(this.deploymentStyle())) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() == null ^ this.blueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() != null
                && !other.blueGreenDeploymentConfiguration().equals(this.blueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.loadBalancerInfo() == null ^ this.loadBalancerInfo() == null) {
            return false;
        }
        if (other.loadBalancerInfo() != null && !other.loadBalancerInfo().equals(this.loadBalancerInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentDeploymentGroupName() != null) {
            sb.append("CurrentDeploymentGroupName: ").append(currentDeploymentGroupName()).append(",");
        }
        if (newDeploymentGroupName() != null) {
            sb.append("NewDeploymentGroupName: ").append(newDeploymentGroupName()).append(",");
        }
        if (deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(deploymentConfigName()).append(",");
        }
        if (ec2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(ec2TagFilters()).append(",");
        }
        if (onPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(onPremisesInstanceTagFilters()).append(",");
        }
        if (autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(autoScalingGroups()).append(",");
        }
        if (serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(serviceRoleArn()).append(",");
        }
        if (triggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(triggerConfigurations()).append(",");
        }
        if (alarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(alarmConfiguration()).append(",");
        }
        if (autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(autoRollbackConfiguration()).append(",");
        }
        if (deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(deploymentStyle()).append(",");
        }
        if (blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(blueGreenDeploymentConfiguration()).append(",");
        }
        if (loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(loadBalancerInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDeploymentGroupRequest> {
        /**
         * <p>
         * The application name corresponding to the deployment group to update.
         * </p>
         * 
         * @param applicationName
         *        The application name corresponding to the deployment group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current name of the deployment group.
         * </p>
         * 
         * @param currentDeploymentGroupName
         *        The current name of the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentDeploymentGroupName(String currentDeploymentGroupName);

        /**
         * <p>
         * The new name of the deployment group, if you want to change it.
         * </p>
         * 
         * @param newDeploymentGroupName
         *        The new name of the deployment group, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDeploymentGroupName(String newDeploymentGroupName);

        /**
         * <p>
         * The replacement deployment configuration name to use, if you want to change it.
         * </p>
         * 
         * @param deploymentConfigName
         *        The replacement deployment configuration name to use, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param ec2TagFilters
         *        The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
         *        existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters);

        /**
         * <p>
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing
         * tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEc2TagFilters(java.util.Collection)} or {@link #withEc2TagFilters(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param ec2TagFilters
         *        The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the
         *        existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2TagFilters(EC2TagFilter... ec2TagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The replacement set of on-premises instance tags on which to filter, if you want to change them. To
         *        keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the
         * existing tags, enter their names. To remove tags, do not enter any tag names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setOnPremisesInstanceTagFilters(java.util.Collection)} or
         * {@link #withOnPremisesInstanceTagFilters(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param onPremisesInstanceTagFilters
         *        The replacement set of on-premises instance tags on which to filter, if you want to change them. To
         *        keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters);

        /**
         * <p>
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
         * them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any
         * Auto Scaling group names.
         * </p>
         * 
         * @param autoScalingGroups
         *        The replacement list of Auto Scaling groups to be included in the deployment group, if you want to
         *        change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not
         *        enter any Auto Scaling group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<String> autoScalingGroups);

        /**
         * <p>
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change
         * them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any
         * Auto Scaling group names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAutoScalingGroups(java.util.Collection)} or {@link #withAutoScalingGroups(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param autoScalingGroups
         *        The replacement list of Auto Scaling groups to be included in the deployment group, if you want to
         *        change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not
         *        enter any Auto Scaling group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(String... autoScalingGroups);

        /**
         * <p>
         * A replacement ARN for the service role, if you want to change it.
         * </p>
         * 
         * @param serviceRoleArn
         *        A replacement ARN for the service role, if you want to change it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an
         * AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers to change when the deployment group is updated. For examples, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers
         *        in an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations);

        /**
         * <p>
         * Information about triggers to change when the deployment group is updated. For examples, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers in an
         * AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTriggerConfigurations(java.util.Collection)} or
         * {@link #withTriggerConfigurations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param triggerConfigurations
         *        Information about triggers to change when the deployment group is updated. For examples, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html">Modify Triggers
         *        in an AWS CodeDeploy Deployment Group</a> in the AWS CodeDeploy User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfigurations(TriggerConfig... triggerConfigurations);

        /**
         * <p>
         * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * </p>
         * 
         * @param alarmConfiguration
         *        Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * Information for an automatic rollback configuration that is added or changed when a deployment group is
         * updated.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Information for an automatic rollback configuration that is added or changed when a deployment group
         *        is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route
         * deployment traffic behind a load balancer.
         * </p>
         * 
         * @param deploymentStyle
         *        Information about the type of deployment, either in-place or blue/green, you want to run and whether
         *        to route deployment traffic behind a load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStyle(DeploymentStyle deploymentStyle);

        /**
         * <p>
         * Information about blue/green deployment options for a deployment group.
         * </p>
         * 
         * @param blueGreenDeploymentConfiguration
         *        Information about blue/green deployment options for a deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration);

        /**
         * <p>
         * Information about the load balancer used in a deployment.
         * </p>
         * 
         * @param loadBalancerInfo
         *        Information about the load balancer used in a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String currentDeploymentGroupName;

        private String newDeploymentGroupName;

        private String deploymentConfigName;

        private List<EC2TagFilter> ec2TagFilters = new SdkInternalList<>();

        private List<TagFilter> onPremisesInstanceTagFilters = new SdkInternalList<>();

        private List<String> autoScalingGroups = new SdkInternalList<>();

        private String serviceRoleArn;

        private List<TriggerConfig> triggerConfigurations = new SdkInternalList<>();

        private AlarmConfiguration alarmConfiguration;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private DeploymentStyle deploymentStyle;

        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;

        private LoadBalancerInfo loadBalancerInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentGroupRequest model) {
            setApplicationName(model.applicationName);
            setCurrentDeploymentGroupName(model.currentDeploymentGroupName);
            setNewDeploymentGroupName(model.newDeploymentGroupName);
            setDeploymentConfigName(model.deploymentConfigName);
            setEc2TagFilters(model.ec2TagFilters);
            setOnPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            setAutoScalingGroups(model.autoScalingGroups);
            setServiceRoleArn(model.serviceRoleArn);
            setTriggerConfigurations(model.triggerConfigurations);
            setAlarmConfiguration(model.alarmConfiguration);
            setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            setDeploymentStyle(model.deploymentStyle);
            setBlueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            setLoadBalancerInfo(model.loadBalancerInfo);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getCurrentDeploymentGroupName() {
            return currentDeploymentGroupName;
        }

        @Override
        public final Builder currentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
            return this;
        }

        public final void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
        }

        public final String getNewDeploymentGroupName() {
            return newDeploymentGroupName;
        }

        @Override
        public final Builder newDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
            return this;
        }

        public final void setNewDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter> getEc2TagFilters() {
            return ec2TagFilters;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter... ec2TagFilters) {
            if (this.ec2TagFilters == null) {
                this.ec2TagFilters = new SdkInternalList<>(ec2TagFilters.length);
            }
            for (EC2TagFilter e : ec2TagFilters) {
                this.ec2TagFilters.add(e);
            }
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
        }

        @SafeVarargs
        public final void setEc2TagFilters(EC2TagFilter... ec2TagFilters) {
            if (this.ec2TagFilters == null) {
                this.ec2TagFilters = new SdkInternalList<>(ec2TagFilters.length);
            }
            for (EC2TagFilter e : ec2TagFilters) {
                this.ec2TagFilters.add(e);
            }
        }

        public final Collection<TagFilter> getOnPremisesInstanceTagFilters() {
            return onPremisesInstanceTagFilters;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            if (this.onPremisesInstanceTagFilters == null) {
                this.onPremisesInstanceTagFilters = new SdkInternalList<>(onPremisesInstanceTagFilters.length);
            }
            for (TagFilter e : onPremisesInstanceTagFilters) {
                this.onPremisesInstanceTagFilters.add(e);
            }
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
        }

        @SafeVarargs
        public final void setOnPremisesInstanceTagFilters(TagFilter... onPremisesInstanceTagFilters) {
            if (this.onPremisesInstanceTagFilters == null) {
                this.onPremisesInstanceTagFilters = new SdkInternalList<>(onPremisesInstanceTagFilters.length);
            }
            for (TagFilter e : onPremisesInstanceTagFilters) {
                this.onPremisesInstanceTagFilters.add(e);
            }
        }

        public final Collection<String> getAutoScalingGroups() {
            return autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList<>(autoScalingGroups.length);
            }
            for (String e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        @SafeVarargs
        public final void setAutoScalingGroups(String... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList<>(autoScalingGroups.length);
            }
            for (String e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<TriggerConfig> getTriggerConfigurations() {
            return triggerConfigurations;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig... triggerConfigurations) {
            if (this.triggerConfigurations == null) {
                this.triggerConfigurations = new SdkInternalList<>(triggerConfigurations.length);
            }
            for (TriggerConfig e : triggerConfigurations) {
                this.triggerConfigurations.add(e);
            }
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
        }

        @SafeVarargs
        public final void setTriggerConfigurations(TriggerConfig... triggerConfigurations) {
            if (this.triggerConfigurations == null) {
                this.triggerConfigurations = new SdkInternalList<>(triggerConfigurations.length);
            }
            for (TriggerConfig e : triggerConfigurations) {
                this.triggerConfigurations.add(e);
            }
        }

        public final AlarmConfiguration getAlarmConfiguration() {
            return alarmConfiguration;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final DeploymentStyle getDeploymentStyle() {
            return deploymentStyle;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
        }

        public final BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
            return blueGreenDeploymentConfiguration;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
        }

        public final LoadBalancerInfo getLoadBalancerInfo() {
            return loadBalancerInfo;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
        }

        @Override
        public UpdateDeploymentGroupRequest build() {
            return new UpdateDeploymentGroupRequest(this);
        }
    }
}
