/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an UpdateApplication operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateApplicationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private final String applicationName;

    private final String newApplicationName;

    private UpdateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.newApplicationName = builder.newApplicationName;
    }

    /**
     * <p>
     * The current name of the application you want to change.
     * </p>
     * 
     * @return The current name of the application you want to change.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The new name to give the application.
     * </p>
     * 
     * @return The new name to give the application.
     */
    public String newApplicationName() {
        return newApplicationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((newApplicationName() == null) ? 0 : newApplicationName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.newApplicationName() == null ^ this.newApplicationName() == null) {
            return false;
        }
        if (other.newApplicationName() != null && !other.newApplicationName().equals(this.newApplicationName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (newApplicationName() != null) {
            sb.append("NewApplicationName: ").append(newApplicationName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * The current name of the application you want to change.
         * </p>
         * 
         * @param applicationName
         *        The current name of the application you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The new name to give the application.
         * </p>
         * 
         * @param newApplicationName
         *        The new name to give the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newApplicationName(String newApplicationName);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String newApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            setApplicationName(model.applicationName);
            setNewApplicationName(model.newApplicationName);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getNewApplicationName() {
            return newApplicationName;
        }

        @Override
        public final Builder newApplicationName(String newApplicationName) {
            this.newApplicationName = newApplicationName;
            return this;
        }

        public final void setNewApplicationName(String newApplicationName) {
            this.newApplicationName = newApplicationName;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }
}
