/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.transform.TriggerConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about notification triggers for the deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TriggerConfig implements StructuredPojo, ToCopyableBuilder<TriggerConfig.Builder, TriggerConfig> {
    private final String triggerName;

    private final String triggerTargetArn;

    private final List<String> triggerEvents;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerName = builder.triggerName;
        this.triggerTargetArn = builder.triggerTargetArn;
        this.triggerEvents = builder.triggerEvents;
    }

    /**
     * <p>
     * The name of the notification trigger.
     * </p>
     * 
     * @return The name of the notification trigger.
     */
    public String triggerName() {
        return triggerName;
    }

    /**
     * <p>
     * The ARN of the Amazon Simple Notification Service topic through which notifications about deployment or instance
     * events are sent.
     * </p>
     * 
     * @return The ARN of the Amazon Simple Notification Service topic through which notifications about deployment or
     *         instance events are sent.
     */
    public String triggerTargetArn() {
        return triggerTargetArn;
    }

    /**
     * <p>
     * The event type or types for which notifications are triggered.
     * </p>
     * 
     * @return The event type or types for which notifications are triggered.
     * @see TriggerEventType
     */
    public List<String> triggerEvents() {
        return triggerEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((triggerName() == null) ? 0 : triggerName().hashCode());
        hashCode = 31 * hashCode + ((triggerTargetArn() == null) ? 0 : triggerTargetArn().hashCode());
        hashCode = 31 * hashCode + ((triggerEvents() == null) ? 0 : triggerEvents().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig) obj;
        if (other.triggerName() == null ^ this.triggerName() == null) {
            return false;
        }
        if (other.triggerName() != null && !other.triggerName().equals(this.triggerName())) {
            return false;
        }
        if (other.triggerTargetArn() == null ^ this.triggerTargetArn() == null) {
            return false;
        }
        if (other.triggerTargetArn() != null && !other.triggerTargetArn().equals(this.triggerTargetArn())) {
            return false;
        }
        if (other.triggerEvents() == null ^ this.triggerEvents() == null) {
            return false;
        }
        if (other.triggerEvents() != null && !other.triggerEvents().equals(this.triggerEvents())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (triggerName() != null) {
            sb.append("TriggerName: ").append(triggerName()).append(",");
        }
        if (triggerTargetArn() != null) {
            sb.append("TriggerTargetArn: ").append(triggerTargetArn()).append(",");
        }
        if (triggerEvents() != null) {
            sb.append("TriggerEvents: ").append(triggerEvents()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TriggerConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TriggerConfig> {
        /**
         * <p>
         * The name of the notification trigger.
         * </p>
         * 
         * @param triggerName
         *        The name of the notification trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerName(String triggerName);

        /**
         * <p>
         * The ARN of the Amazon Simple Notification Service topic through which notifications about deployment or
         * instance events are sent.
         * </p>
         * 
         * @param triggerTargetArn
         *        The ARN of the Amazon Simple Notification Service topic through which notifications about deployment
         *        or instance events are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerTargetArn(String triggerTargetArn);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerEventType
         */
        Builder triggerEvents(Collection<String> triggerEvents);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTriggerEvents(java.util.Collection)} or {@link #withTriggerEvents(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerEventType
         */
        Builder triggerEvents(String... triggerEvents);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTriggerEvents(java.util.Collection)} or {@link #withTriggerEvents(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerEventType
         */
        Builder triggerEvents(TriggerEventType... triggerEvents);
    }

    private static final class BuilderImpl implements Builder {
        private String triggerName;

        private String triggerTargetArn;

        private List<String> triggerEvents = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            setTriggerName(model.triggerName);
            setTriggerTargetArn(model.triggerTargetArn);
            setTriggerEvents(model.triggerEvents);
        }

        public final String getTriggerName() {
            return triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public final String getTriggerTargetArn() {
            return triggerTargetArn;
        }

        @Override
        public final Builder triggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
            return this;
        }

        public final void setTriggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
        }

        public final Collection<String> getTriggerEvents() {
            return triggerEvents;
        }

        @Override
        public final Builder triggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEvents(String... triggerEvents) {
            if (this.triggerEvents == null) {
                this.triggerEvents = new SdkInternalList<>(triggerEvents.length);
            }
            for (String e : triggerEvents) {
                this.triggerEvents.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEvents(TriggerEventType... triggerEvents) {
            if (this.triggerEvents == null) {
                this.triggerEvents = new SdkInternalList<String>(triggerEvents.length);
            }
            for (TriggerEventType ele : triggerEvents) {
                this.triggerEvents.add(ele.toString());
            }
            return this;
        }

        public final void setTriggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
        }

        @SafeVarargs
        public final void setTriggerEvents(String... triggerEvents) {
            if (this.triggerEvents == null) {
                this.triggerEvents = new SdkInternalList<>(triggerEvents.length);
            }
            for (String e : triggerEvents) {
                this.triggerEvents.add(e);
            }
        }

        @SafeVarargs
        public final void setTriggerEvents(TriggerEventType... triggerEvents) {
            if (this.triggerEvents == null) {
                this.triggerEvents = new SdkInternalList<String>(triggerEvents.length);
            }
            for (TriggerEventType ele : triggerEvents) {
                this.triggerEvents.add(ele.toString());
            }
        }

        @Override
        public TriggerConfig build() {
            return new TriggerConfig(this);
        }
    }
}
