/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.transform.TargetInstancesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instances to be used in the replacement environment in a blue/green deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetInstances implements StructuredPojo, ToCopyableBuilder<TargetInstances.Builder, TargetInstances> {
    private final List<EC2TagFilter> tagFilters;

    private final List<String> autoScalingGroups;

    private TargetInstances(BuilderImpl builder) {
        this.tagFilters = builder.tagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
    }

    /**
     * <p>
     * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
     * blue/green deployment.
     * </p>
     * 
     * @return The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment
     *         for a blue/green deployment.
     */
    public List<EC2TagFilter> tagFilters() {
        return tagFilters;
    }

    /**
     * <p>
     * The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green deployment.
     * </p>
     * 
     * @return The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
     *         deployment.
     */
    public List<String> autoScalingGroups() {
        return autoScalingGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tagFilters() == null) ? 0 : tagFilters().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroups() == null) ? 0 : autoScalingGroups().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstances)) {
            return false;
        }
        TargetInstances other = (TargetInstances) obj;
        if (other.tagFilters() == null ^ this.tagFilters() == null) {
            return false;
        }
        if (other.tagFilters() != null && !other.tagFilters().equals(this.tagFilters())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tagFilters() != null) {
            sb.append("TagFilters: ").append(tagFilters()).append(",");
        }
        if (autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(autoScalingGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetInstancesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TargetInstances> {
        /**
         * <p>
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
         * blue/green deployment.
         * </p>
         * 
         * @param tagFilters
         *        The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment
         *        for a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<EC2TagFilter> tagFilters);

        /**
         * <p>
         * The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment for a
         * blue/green deployment.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagFilters(java.util.Collection)} or {@link #withTagFilters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagFilters
         *        The tag filter key, type, and value used to identify Amazon EC2 instances in a replacement environment
         *        for a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(EC2TagFilter... tagFilters);

        /**
         * <p>
         * The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         * deployment.
         * </p>
         * 
         * @param autoScalingGroups
         *        The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(Collection<String> autoScalingGroups);

        /**
         * <p>
         * The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         * deployment.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAutoScalingGroups(java.util.Collection)} or {@link #withAutoScalingGroups(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param autoScalingGroups
         *        The names of one or more Auto Scaling groups to identify a replacement environment for a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroups(String... autoScalingGroups);
    }

    private static final class BuilderImpl implements Builder {
        private List<EC2TagFilter> tagFilters = new SdkInternalList<>();

        private List<String> autoScalingGroups = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstances model) {
            setTagFilters(model.tagFilters);
            setAutoScalingGroups(model.autoScalingGroups);
        }

        public final Collection<EC2TagFilter> getTagFilters() {
            return tagFilters;
        }

        @Override
        public final Builder tagFilters(Collection<EC2TagFilter> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(EC2TagFilter... tagFilters) {
            if (this.tagFilters == null) {
                this.tagFilters = new SdkInternalList<>(tagFilters.length);
            }
            for (EC2TagFilter e : tagFilters) {
                this.tagFilters.add(e);
            }
            return this;
        }

        public final void setTagFilters(Collection<EC2TagFilter> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copy(tagFilters);
        }

        @SafeVarargs
        public final void setTagFilters(EC2TagFilter... tagFilters) {
            if (this.tagFilters == null) {
                this.tagFilters = new SdkInternalList<>(tagFilters.length);
            }
            for (EC2TagFilter e : tagFilters) {
                this.tagFilters.add(e);
            }
        }

        public final Collection<String> getAutoScalingGroups() {
            return autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList<>(autoScalingGroups.length);
            }
            for (String e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        @SafeVarargs
        public final void setAutoScalingGroups(String... autoScalingGroups) {
            if (this.autoScalingGroups == null) {
                this.autoScalingGroups = new SdkInternalList<>(autoScalingGroups.length);
            }
            for (String e : autoScalingGroups) {
                this.autoScalingGroups.add(e);
            }
        }

        @Override
        public TargetInstances build() {
            return new TargetInstances(this);
        }
    }
}
