/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a StopDeployment operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopDeploymentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<StopDeploymentResponse.Builder, StopDeploymentResponse> {
    private final String status;

    private final String statusMessage;

    private StopDeploymentResponse(BuilderImpl builder) {
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The status of the stop deployment operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The stop operation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: The stop operation was successful.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the stop deployment operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The stop operation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: The stop operation was successful.
     *         </p>
     *         </li>
     * @see StopStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * An accompanying status message.
     * </p>
     * 
     * @return An accompanying status message.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentResponse)) {
            return false;
        }
        StopDeploymentResponse other = (StopDeploymentResponse) obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StopDeploymentResponse> {
        /**
         * <p>
         * The status of the stop deployment operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The stop operation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The stop operation was successful.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stop deployment operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The stop operation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The stop operation was successful.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the stop deployment operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The stop operation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The stop operation was successful.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stop deployment operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The stop operation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The stop operation was successful.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopStatus
         */
        Builder status(StopStatus status);

        /**
         * <p>
         * An accompanying status message.
         * </p>
         * 
         * @param statusMessage
         *        An accompanying status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentResponse model) {
            setStatus(model.status);
            setStatusMessage(model.statusMessage);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StopStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(StopStatus status) {
            this.status(status.toString());
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public StopDeploymentResponse build() {
            return new StopDeploymentResponse(this);
        }
    }
}
