/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a StopDeployment operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopDeploymentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<StopDeploymentRequest.Builder, StopDeploymentRequest> {
    private final String deploymentId;

    private final Boolean autoRollbackEnabled;

    private StopDeploymentRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.autoRollbackEnabled = builder.autoRollbackEnabled;
    }

    /**
     * <p>
     * The unique ID of a deployment.
     * </p>
     * 
     * @return The unique ID of a deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the
     * previous version of the application revision.
     * </p>
     * 
     * @return Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back
     *         to the previous version of the application revision.
     */
    public Boolean autoRollbackEnabled() {
        return autoRollbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((autoRollbackEnabled() == null) ? 0 : autoRollbackEnabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentRequest)) {
            return false;
        }
        StopDeploymentRequest other = (StopDeploymentRequest) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.autoRollbackEnabled() == null ^ this.autoRollbackEnabled() == null) {
            return false;
        }
        if (other.autoRollbackEnabled() != null && !other.autoRollbackEnabled().equals(this.autoRollbackEnabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (autoRollbackEnabled() != null) {
            sb.append("AutoRollbackEnabled: ").append(autoRollbackEnabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StopDeploymentRequest> {
        /**
         * <p>
         * The unique ID of a deployment.
         * </p>
         * 
         * @param deploymentId
         *        The unique ID of a deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to
         * the previous version of the application revision.
         * </p>
         * 
         * @param autoRollbackEnabled
         *        Indicates, when a deployment is stopped, whether instances that have been updated should be rolled
         *        back to the previous version of the application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackEnabled(Boolean autoRollbackEnabled);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private Boolean autoRollbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentRequest model) {
            setDeploymentId(model.deploymentId);
            setAutoRollbackEnabled(model.autoRollbackEnabled);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Boolean getAutoRollbackEnabled() {
            return autoRollbackEnabled;
        }

        @Override
        public final Builder autoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
            return this;
        }

        public final void setAutoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
        }

        @Override
        public StopDeploymentRequest build() {
            return new StopDeploymentRequest(this);
        }
    }
}
