/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.S3LocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of application artifacts stored in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Location implements StructuredPojo, ToCopyableBuilder<S3Location.Builder, S3Location> {
    private final String bucket;

    private final String key;

    private final String bundleType;

    private final String version;

    private final String eTag;

    private S3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.bundleType = builder.bundleType;
        this.version = builder.version;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where the application revision is stored.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where the application revision is stored.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
     * </p>
     * 
     * @return The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The file type of the application revision. Must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tar: A tar archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * tgz: A compressed tar archive file.
     * </p>
     * </li>
     * <li>
     * <p>
     * zip: A zip archive file.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The file type of the application revision. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         tar: A tar archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         tgz: A compressed tar archive file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         zip: A zip archive file.
     *         </p>
     *         </li>
     * @see BundleType
     */
    public String bundleType() {
        return bundleType;
    }

    /**
     * <p>
     * A specific version of the Amazon S3 object that represents the bundled artifacts for the application revision.
     * </p>
     * <p>
     * If the version is not specified, the system will use the most recent version by default.
     * </p>
     * 
     * @return A specific version of the Amazon S3 object that represents the bundled artifacts for the application
     *         revision.</p>
     *         <p>
     *         If the version is not specified, the system will use the most recent version by default.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
     * </p>
     * <p>
     * If the ETag is not specified as an input parameter, ETag validation of the object will be skipped.
     * </p>
     * 
     * @return The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.</p>
     *         <p>
     *         If the ETag is not specified as an input parameter, ETag validation of the object will be skipped.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((bundleType() == null) ? 0 : bundleType().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.bundleType() == null ^ this.bundleType() == null) {
            return false;
        }
        if (other.bundleType() != null && !other.bundleType().equals(this.bundleType())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (bundleType() != null) {
            sb.append("BundleType: ").append(bundleType()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3Location> {
        /**
         * <p>
         * The name of the Amazon S3 bucket where the application revision is stored.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket where the application revision is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * </p>
         * 
         * @param key
         *        The name of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The file type of the application revision. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * tar: A tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * tgz: A compressed tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * zip: A zip archive file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bundleType
         *        The file type of the application revision. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        tar: A tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        tgz: A compressed tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        zip: A zip archive file.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleType
         */
        Builder bundleType(String bundleType);

        /**
         * <p>
         * The file type of the application revision. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * tar: A tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * tgz: A compressed tar archive file.
         * </p>
         * </li>
         * <li>
         * <p>
         * zip: A zip archive file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bundleType
         *        The file type of the application revision. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        tar: A tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        tgz: A compressed tar archive file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        zip: A zip archive file.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleType
         */
        Builder bundleType(BundleType bundleType);

        /**
         * <p>
         * A specific version of the Amazon S3 object that represents the bundled artifacts for the application
         * revision.
         * </p>
         * <p>
         * If the version is not specified, the system will use the most recent version by default.
         * </p>
         * 
         * @param version
         *        A specific version of the Amazon S3 object that represents the bundled artifacts for the application
         *        revision.</p>
         *        <p>
         *        If the version is not specified, the system will use the most recent version by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The ETag of the Amazon S3 object that represents the bundled artifacts for the application revision.
         * </p>
         * <p>
         * If the ETag is not specified as an input parameter, ETag validation of the object will be skipped.
         * </p>
         * 
         * @param eTag
         *        The ETag of the Amazon S3 object that represents the bundled artifacts for the application
         *        revision.</p>
         *        <p>
         *        If the ETag is not specified as an input parameter, ETag validation of the object will be skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private String bundleType;

        private String version;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            setBucket(model.bucket);
            setKey(model.key);
            setBundleType(model.bundleType);
            setVersion(model.version);
            setETag(model.eTag);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getBundleType() {
            return bundleType;
        }

        @Override
        public final Builder bundleType(String bundleType) {
            this.bundleType = bundleType;
            return this;
        }

        @Override
        public final Builder bundleType(BundleType bundleType) {
            this.bundleType(bundleType.toString());
            return this;
        }

        public final void setBundleType(String bundleType) {
            this.bundleType = bundleType;
        }

        public final void setBundleType(BundleType bundleType) {
            this.bundleType(bundleType.toString());
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }
    }
}
