/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.RollbackInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment rollback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RollbackInfo implements StructuredPojo, ToCopyableBuilder<RollbackInfo.Builder, RollbackInfo> {
    private final String rollbackDeploymentId;

    private final String rollbackTriggeringDeploymentId;

    private final String rollbackMessage;

    private RollbackInfo(BuilderImpl builder) {
        this.rollbackDeploymentId = builder.rollbackDeploymentId;
        this.rollbackTriggeringDeploymentId = builder.rollbackTriggeringDeploymentId;
        this.rollbackMessage = builder.rollbackMessage;
    }

    /**
     * <p>
     * The ID of the deployment rollback.
     * </p>
     * 
     * @return The ID of the deployment rollback.
     */
    public String rollbackDeploymentId() {
        return rollbackDeploymentId;
    }

    /**
     * <p>
     * The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed or
     * was stopped.
     * </p>
     * 
     * @return The deployment ID of the deployment that was underway and triggered a rollback deployment because it
     *         failed or was stopped.
     */
    public String rollbackTriggeringDeploymentId() {
        return rollbackTriggeringDeploymentId;
    }

    /**
     * <p>
     * Information describing the status of a deployment rollback; for example, whether the deployment can't be rolled
     * back, is in progress, failed, or succeeded.
     * </p>
     * 
     * @return Information describing the status of a deployment rollback; for example, whether the deployment can't be
     *         rolled back, is in progress, failed, or succeeded.
     */
    public String rollbackMessage() {
        return rollbackMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((rollbackDeploymentId() == null) ? 0 : rollbackDeploymentId().hashCode());
        hashCode = 31 * hashCode + ((rollbackTriggeringDeploymentId() == null) ? 0 : rollbackTriggeringDeploymentId().hashCode());
        hashCode = 31 * hashCode + ((rollbackMessage() == null) ? 0 : rollbackMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackInfo)) {
            return false;
        }
        RollbackInfo other = (RollbackInfo) obj;
        if (other.rollbackDeploymentId() == null ^ this.rollbackDeploymentId() == null) {
            return false;
        }
        if (other.rollbackDeploymentId() != null && !other.rollbackDeploymentId().equals(this.rollbackDeploymentId())) {
            return false;
        }
        if (other.rollbackTriggeringDeploymentId() == null ^ this.rollbackTriggeringDeploymentId() == null) {
            return false;
        }
        if (other.rollbackTriggeringDeploymentId() != null
                && !other.rollbackTriggeringDeploymentId().equals(this.rollbackTriggeringDeploymentId())) {
            return false;
        }
        if (other.rollbackMessage() == null ^ this.rollbackMessage() == null) {
            return false;
        }
        if (other.rollbackMessage() != null && !other.rollbackMessage().equals(this.rollbackMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (rollbackDeploymentId() != null) {
            sb.append("RollbackDeploymentId: ").append(rollbackDeploymentId()).append(",");
        }
        if (rollbackTriggeringDeploymentId() != null) {
            sb.append("RollbackTriggeringDeploymentId: ").append(rollbackTriggeringDeploymentId()).append(",");
        }
        if (rollbackMessage() != null) {
            sb.append("RollbackMessage: ").append(rollbackMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RollbackInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RollbackInfo> {
        /**
         * <p>
         * The ID of the deployment rollback.
         * </p>
         * 
         * @param rollbackDeploymentId
         *        The ID of the deployment rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackDeploymentId(String rollbackDeploymentId);

        /**
         * <p>
         * The deployment ID of the deployment that was underway and triggered a rollback deployment because it failed
         * or was stopped.
         * </p>
         * 
         * @param rollbackTriggeringDeploymentId
         *        The deployment ID of the deployment that was underway and triggered a rollback deployment because it
         *        failed or was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackTriggeringDeploymentId(String rollbackTriggeringDeploymentId);

        /**
         * <p>
         * Information describing the status of a deployment rollback; for example, whether the deployment can't be
         * rolled back, is in progress, failed, or succeeded.
         * </p>
         * 
         * @param rollbackMessage
         *        Information describing the status of a deployment rollback; for example, whether the deployment can't
         *        be rolled back, is in progress, failed, or succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackMessage(String rollbackMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String rollbackDeploymentId;

        private String rollbackTriggeringDeploymentId;

        private String rollbackMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackInfo model) {
            setRollbackDeploymentId(model.rollbackDeploymentId);
            setRollbackTriggeringDeploymentId(model.rollbackTriggeringDeploymentId);
            setRollbackMessage(model.rollbackMessage);
        }

        public final String getRollbackDeploymentId() {
            return rollbackDeploymentId;
        }

        @Override
        public final Builder rollbackDeploymentId(String rollbackDeploymentId) {
            this.rollbackDeploymentId = rollbackDeploymentId;
            return this;
        }

        public final void setRollbackDeploymentId(String rollbackDeploymentId) {
            this.rollbackDeploymentId = rollbackDeploymentId;
        }

        public final String getRollbackTriggeringDeploymentId() {
            return rollbackTriggeringDeploymentId;
        }

        @Override
        public final Builder rollbackTriggeringDeploymentId(String rollbackTriggeringDeploymentId) {
            this.rollbackTriggeringDeploymentId = rollbackTriggeringDeploymentId;
            return this;
        }

        public final void setRollbackTriggeringDeploymentId(String rollbackTriggeringDeploymentId) {
            this.rollbackTriggeringDeploymentId = rollbackTriggeringDeploymentId;
        }

        public final String getRollbackMessage() {
            return rollbackMessage;
        }

        @Override
        public final Builder rollbackMessage(String rollbackMessage) {
            this.rollbackMessage = rollbackMessage;
            return this;
        }

        public final void setRollbackMessage(String rollbackMessage) {
            this.rollbackMessage = rollbackMessage;
        }

        @Override
        public RollbackInfo build() {
            return new RollbackInfo(this);
        }
    }
}
