/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.RevisionLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location of an application revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RevisionLocation implements StructuredPojo, ToCopyableBuilder<RevisionLocation.Builder, RevisionLocation> {
    private final String revisionType;

    private final S3Location s3Location;

    private final GitHubLocation gitHubLocation;

    private RevisionLocation(BuilderImpl builder) {
        this.revisionType = builder.revisionType;
        this.s3Location = builder.s3Location;
        this.gitHubLocation = builder.gitHubLocation;
    }

    /**
     * <p>
     * The type of application revision:
     * </p>
     * <ul>
     * <li>
     * <p>
     * S3: An application revision stored in Amazon S3.
     * </p>
     * </li>
     * <li>
     * <p>
     * GitHub: An application revision stored in GitHub.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of application revision:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         S3: An application revision stored in Amazon S3.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GitHub: An application revision stored in GitHub.
     *         </p>
     *         </li>
     * @see RevisionLocationType
     */
    public String revisionType() {
        return revisionType;
    }

    /**
     * <p>
     * Information about the location of application artifacts stored in Amazon S3.
     * </p>
     * 
     * @return Information about the location of application artifacts stored in Amazon S3.
     */
    public S3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * Information about the location of application artifacts stored in GitHub.
     * </p>
     * 
     * @return Information about the location of application artifacts stored in GitHub.
     */
    public GitHubLocation gitHubLocation() {
        return gitHubLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((revisionType() == null) ? 0 : revisionType().hashCode());
        hashCode = 31 * hashCode + ((s3Location() == null) ? 0 : s3Location().hashCode());
        hashCode = 31 * hashCode + ((gitHubLocation() == null) ? 0 : gitHubLocation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionLocation)) {
            return false;
        }
        RevisionLocation other = (RevisionLocation) obj;
        if (other.revisionType() == null ^ this.revisionType() == null) {
            return false;
        }
        if (other.revisionType() != null && !other.revisionType().equals(this.revisionType())) {
            return false;
        }
        if (other.s3Location() == null ^ this.s3Location() == null) {
            return false;
        }
        if (other.s3Location() != null && !other.s3Location().equals(this.s3Location())) {
            return false;
        }
        if (other.gitHubLocation() == null ^ this.gitHubLocation() == null) {
            return false;
        }
        if (other.gitHubLocation() != null && !other.gitHubLocation().equals(this.gitHubLocation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (revisionType() != null) {
            sb.append("RevisionType: ").append(revisionType()).append(",");
        }
        if (s3Location() != null) {
            sb.append("S3Location: ").append(s3Location()).append(",");
        }
        if (gitHubLocation() != null) {
            sb.append("GitHubLocation: ").append(gitHubLocation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RevisionLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RevisionLocation> {
        /**
         * <p>
         * The type of application revision:
         * </p>
         * <ul>
         * <li>
         * <p>
         * S3: An application revision stored in Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * GitHub: An application revision stored in GitHub.
         * </p>
         * </li>
         * </ul>
         * 
         * @param revisionType
         *        The type of application revision:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        S3: An application revision stored in Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GitHub: An application revision stored in GitHub.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevisionLocationType
         */
        Builder revisionType(String revisionType);

        /**
         * <p>
         * The type of application revision:
         * </p>
         * <ul>
         * <li>
         * <p>
         * S3: An application revision stored in Amazon S3.
         * </p>
         * </li>
         * <li>
         * <p>
         * GitHub: An application revision stored in GitHub.
         * </p>
         * </li>
         * </ul>
         * 
         * @param revisionType
         *        The type of application revision:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        S3: An application revision stored in Amazon S3.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GitHub: An application revision stored in GitHub.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevisionLocationType
         */
        Builder revisionType(RevisionLocationType revisionType);

        /**
         * <p>
         * Information about the location of application artifacts stored in Amazon S3.
         * </p>
         * 
         * @param s3Location
         *        Information about the location of application artifacts stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3Location s3Location);

        /**
         * <p>
         * Information about the location of application artifacts stored in GitHub.
         * </p>
         * 
         * @param gitHubLocation
         *        Information about the location of application artifacts stored in GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitHubLocation(GitHubLocation gitHubLocation);
    }

    private static final class BuilderImpl implements Builder {
        private String revisionType;

        private S3Location s3Location;

        private GitHubLocation gitHubLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionLocation model) {
            setRevisionType(model.revisionType);
            setS3Location(model.s3Location);
            setGitHubLocation(model.gitHubLocation);
        }

        public final String getRevisionType() {
            return revisionType;
        }

        @Override
        public final Builder revisionType(String revisionType) {
            this.revisionType = revisionType;
            return this;
        }

        @Override
        public final Builder revisionType(RevisionLocationType revisionType) {
            this.revisionType(revisionType.toString());
            return this;
        }

        public final void setRevisionType(String revisionType) {
            this.revisionType = revisionType;
        }

        public final void setRevisionType(RevisionLocationType revisionType) {
            this.revisionType(revisionType.toString());
        }

        public final S3Location getS3Location() {
            return s3Location;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location s3Location) {
            this.s3Location = s3Location;
        }

        public final GitHubLocation getGitHubLocation() {
            return gitHubLocation;
        }

        @Override
        public final Builder gitHubLocation(GitHubLocation gitHubLocation) {
            this.gitHubLocation = gitHubLocation;
            return this;
        }

        public final void setGitHubLocation(GitHubLocation gitHubLocation) {
            this.gitHubLocation = gitHubLocation;
        }

        @Override
        public RevisionLocation build() {
            return new RevisionLocation(this);
        }
    }
}
