/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.RevisionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RevisionInfo implements StructuredPojo, ToCopyableBuilder<RevisionInfo.Builder, RevisionInfo> {
    private final RevisionLocation revisionLocation;

    private final GenericRevisionInfo genericRevisionInfo;

    private RevisionInfo(BuilderImpl builder) {
        this.revisionLocation = builder.revisionLocation;
        this.genericRevisionInfo = builder.genericRevisionInfo;
    }

    /**
     * <p>
     * Information about the location and type of an application revision.
     * </p>
     * 
     * @return Information about the location and type of an application revision.
     */
    public RevisionLocation revisionLocation() {
        return revisionLocation;
    }

    /**
     * <p>
     * Information about an application revision, including usage details and associated deployment groups.
     * </p>
     * 
     * @return Information about an application revision, including usage details and associated deployment groups.
     */
    public GenericRevisionInfo genericRevisionInfo() {
        return genericRevisionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((revisionLocation() == null) ? 0 : revisionLocation().hashCode());
        hashCode = 31 * hashCode + ((genericRevisionInfo() == null) ? 0 : genericRevisionInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionInfo)) {
            return false;
        }
        RevisionInfo other = (RevisionInfo) obj;
        if (other.revisionLocation() == null ^ this.revisionLocation() == null) {
            return false;
        }
        if (other.revisionLocation() != null && !other.revisionLocation().equals(this.revisionLocation())) {
            return false;
        }
        if (other.genericRevisionInfo() == null ^ this.genericRevisionInfo() == null) {
            return false;
        }
        if (other.genericRevisionInfo() != null && !other.genericRevisionInfo().equals(this.genericRevisionInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (revisionLocation() != null) {
            sb.append("RevisionLocation: ").append(revisionLocation()).append(",");
        }
        if (genericRevisionInfo() != null) {
            sb.append("GenericRevisionInfo: ").append(genericRevisionInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RevisionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RevisionInfo> {
        /**
         * <p>
         * Information about the location and type of an application revision.
         * </p>
         * 
         * @param revisionLocation
         *        Information about the location and type of an application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionLocation(RevisionLocation revisionLocation);

        /**
         * <p>
         * Information about an application revision, including usage details and associated deployment groups.
         * </p>
         * 
         * @param genericRevisionInfo
         *        Information about an application revision, including usage details and associated deployment groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genericRevisionInfo(GenericRevisionInfo genericRevisionInfo);
    }

    private static final class BuilderImpl implements Builder {
        private RevisionLocation revisionLocation;

        private GenericRevisionInfo genericRevisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionInfo model) {
            setRevisionLocation(model.revisionLocation);
            setGenericRevisionInfo(model.genericRevisionInfo);
        }

        public final RevisionLocation getRevisionLocation() {
            return revisionLocation;
        }

        @Override
        public final Builder revisionLocation(RevisionLocation revisionLocation) {
            this.revisionLocation = revisionLocation;
            return this;
        }

        public final void setRevisionLocation(RevisionLocation revisionLocation) {
            this.revisionLocation = revisionLocation;
        }

        public final GenericRevisionInfo getGenericRevisionInfo() {
            return genericRevisionInfo;
        }

        @Override
        public final Builder genericRevisionInfo(GenericRevisionInfo genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo;
            return this;
        }

        public final void setGenericRevisionInfo(GenericRevisionInfo genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo;
        }

        @Override
        public RevisionInfo build() {
            return new RevisionInfo(this);
        }
    }
}
