/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of the register on-premises instance operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterOnPremisesInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterOnPremisesInstanceRequest.Builder, RegisterOnPremisesInstanceRequest> {
    private final String instanceName;

    private final String iamSessionArn;

    private final String iamUserArn;

    private RegisterOnPremisesInstanceRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
    }

    /**
     * <p>
     * The name of the on-premises instance to register.
     * </p>
     * 
     * @return The name of the on-premises instance to register.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The ARN of the IAM session to associate with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM session to associate with the on-premises instance.
     */
    public String iamSessionArn() {
        return iamSessionArn;
    }

    /**
     * <p>
     * The ARN of the IAM user to associate with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM user to associate with the on-premises instance.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceName() == null) ? 0 : instanceName().hashCode());
        hashCode = 31 * hashCode + ((iamSessionArn() == null) ? 0 : iamSessionArn().hashCode());
        hashCode = 31 * hashCode + ((iamUserArn() == null) ? 0 : iamUserArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOnPremisesInstanceRequest)) {
            return false;
        }
        RegisterOnPremisesInstanceRequest other = (RegisterOnPremisesInstanceRequest) obj;
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.iamSessionArn() == null ^ this.iamSessionArn() == null) {
            return false;
        }
        if (other.iamSessionArn() != null && !other.iamSessionArn().equals(this.iamSessionArn())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceName() != null) {
            sb.append("InstanceName: ").append(instanceName()).append(",");
        }
        if (iamSessionArn() != null) {
            sb.append("IamSessionArn: ").append(iamSessionArn()).append(",");
        }
        if (iamUserArn() != null) {
            sb.append("IamUserArn: ").append(iamUserArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
        /**
         * <p>
         * The name of the on-premises instance to register.
         * </p>
         * 
         * @param instanceName
         *        The name of the on-premises instance to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The ARN of the IAM session to associate with the on-premises instance.
         * </p>
         * 
         * @param iamSessionArn
         *        The ARN of the IAM session to associate with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamSessionArn(String iamSessionArn);

        /**
         * <p>
         * The ARN of the IAM user to associate with the on-premises instance.
         * </p>
         * 
         * @param iamUserArn
         *        The ARN of the IAM user to associate with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceName;

        private String iamSessionArn;

        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOnPremisesInstanceRequest model) {
            setInstanceName(model.instanceName);
            setIamSessionArn(model.iamSessionArn);
            setIamUserArn(model.iamUserArn);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public RegisterOnPremisesInstanceRequest build() {
            return new RegisterOnPremisesInstanceRequest(this);
        }
    }
}
