/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.MinimumHealthyHostsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about minimum healthy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MinimumHealthyHosts implements StructuredPojo, ToCopyableBuilder<MinimumHealthyHosts.Builder, MinimumHealthyHosts> {
    private final Integer value;

    private final String type;

    private MinimumHealthyHosts(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * The minimum healthy instance value.
     * </p>
     * 
     * @return The minimum healthy instance value.
     */
    public Integer value() {
        return value;
    }

    /**
     * <p>
     * The minimum healthy instance type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HOST_COUNT: The minimum number of healthy instance as an absolute value.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
     * deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a time.
     * The deployment will be successful if six or more instances are deployed to successfully; otherwise, the
     * deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The deployment
     * will be successful if four or more instance are deployed to successfully; otherwise, the deployment fails.
     * </p>
     * <note>
     * <p>
     * In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a minimum
     * healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a
     * time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
     * CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that all instances but one are kept in a healthy
     * state during the deployment. Although this allows one instance at a time to be taken offline for a new
     * deployment, it also means that if the deployment to the last instance fails, the overall deployment still
     * succeeds.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
     * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
     * </p>
     * 
     * @return The minimum healthy instance type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         HOST_COUNT: The minimum number of healthy instance as an absolute value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in
     *         the deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
     *         time. The deployment will be successful if six or more instances are deployed to successfully; otherwise,
     *         the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
     *         deployment will be successful if four or more instance are deployed to successfully; otherwise, the
     *         deployment fails.
     *         </p>
     *         <note>
     *         <p>
     *         In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a
     *         minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one
     *         instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.)
     *         In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that all instances but
     *         one are kept in a healthy state during the deployment. Although this allows one instance at a time to be
     *         taken offline for a new deployment, it also means that if the deployment to the last instance fails, the
     *         overall deployment still succeeds.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
     *         Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
     * @see MinimumHealthyHostsType
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinimumHealthyHosts)) {
            return false;
        }
        MinimumHealthyHosts other = (MinimumHealthyHosts) obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MinimumHealthyHostsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MinimumHealthyHosts> {
        /**
         * <p>
         * The minimum healthy instance value.
         * </p>
         * 
         * @param value
         *        The minimum healthy instance value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * The minimum healthy instance type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The minimum number of healthy instance as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
         * deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
         * time. The deployment will be successful if six or more instances are deployed to successfully; otherwise, the
         * deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
         * deployment will be successful if four or more instance are deployed to successfully; otherwise, the
         * deployment fails.
         * </p>
         * <note>
         * <p>
         * In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a minimum
         * healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a
         * time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
         * CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that all instances but one are kept in a
         * healthy state during the deployment. Although this allows one instance at a time to be taken offline for a
         * new deployment, it also means that if the deployment to the last instance fails, the overall deployment still
         * succeeds.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
         * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param type
         *        The minimum healthy instance type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The minimum number of healthy instance as an absolute value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance
         *        in the deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances
         *        at a time. The deployment will be successful if six or more instances are deployed to successfully;
         *        otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance
         *        at a time. The deployment will be successful if four or more instance are deployed to successfully;
         *        otherwise, the deployment fails.
         *        </p>
         *        <note>
         *        <p>
         *        In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a
         *        minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only
         *        one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or
         *        FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that
         *        all instances but one are kept in a healthy state during the deployment. Although this allows one
         *        instance at a time to be taken offline for a new deployment, it also means that if the deployment to
         *        the last instance fails, the overall deployment still succeeds.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
         *        Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumHealthyHostsType
         */
        Builder type(String type);

        /**
         * <p>
         * The minimum healthy instance type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The minimum number of healthy instance as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
         * deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
         * time. The deployment will be successful if six or more instances are deployed to successfully; otherwise, the
         * deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
         * deployment will be successful if four or more instance are deployed to successfully; otherwise, the
         * deployment fails.
         * </p>
         * <note>
         * <p>
         * In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a minimum
         * healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a
         * time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
         * CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that all instances but one are kept in a
         * healthy state during the deployment. Although this allows one instance at a time to be taken offline for a
         * new deployment, it also means that if the deployment to the last instance fails, the overall deployment still
         * succeeds.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
         * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param type
         *        The minimum healthy instance type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The minimum number of healthy instance as an absolute value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance
         *        in the deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances
         *        at a time. The deployment will be successful if six or more instances are deployed to successfully;
         *        otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance
         *        at a time. The deployment will be successful if four or more instance are deployed to successfully;
         *        otherwise, the deployment fails.
         *        </p>
         *        <note>
         *        <p>
         *        In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime will return a
         *        minimum healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only
         *        one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or
         *        FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure that
         *        all instances but one are kept in a healthy state during the deployment. Although this allows one
         *        instance at a time to be taken offline for a new deployment, it also means that if the deployment to
         *        the last instance fails, the overall deployment still succeeds.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
         *        Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumHealthyHostsType
         */
        Builder type(MinimumHealthyHostsType type);
    }

    private static final class BuilderImpl implements Builder {
        private Integer value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MinimumHealthyHosts model) {
            setValue(model.value);
            setType(model.type);
        }

        public final Integer getValue() {
            return value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MinimumHealthyHostsType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(MinimumHealthyHostsType type) {
            this.type(type.toString());
        }

        @Override
        public MinimumHealthyHosts build() {
            return new MinimumHealthyHosts(this);
        }
    }
}
