/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.transform.LoadBalancerInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the load balancer used in a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoadBalancerInfo implements StructuredPojo, ToCopyableBuilder<LoadBalancerInfo.Builder, LoadBalancerInfo> {
    private final List<ELBInfo> elbInfoList;

    private LoadBalancerInfo(BuilderImpl builder) {
        this.elbInfoList = builder.elbInfoList;
    }

    /**
     * <p>
     * An array containing information about the load balancer in Elastic Load Balancing to use in a deployment.
     * </p>
     * 
     * @return An array containing information about the load balancer in Elastic Load Balancing to use in a deployment.
     */
    public List<ELBInfo> elbInfoList() {
        return elbInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((elbInfoList() == null) ? 0 : elbInfoList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerInfo)) {
            return false;
        }
        LoadBalancerInfo other = (LoadBalancerInfo) obj;
        if (other.elbInfoList() == null ^ this.elbInfoList() == null) {
            return false;
        }
        if (other.elbInfoList() != null && !other.elbInfoList().equals(this.elbInfoList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (elbInfoList() != null) {
            sb.append("ElbInfoList: ").append(elbInfoList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LoadBalancerInfo> {
        /**
         * <p>
         * An array containing information about the load balancer in Elastic Load Balancing to use in a deployment.
         * </p>
         * 
         * @param elbInfoList
         *        An array containing information about the load balancer in Elastic Load Balancing to use in a
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elbInfoList(Collection<ELBInfo> elbInfoList);

        /**
         * <p>
         * An array containing information about the load balancer in Elastic Load Balancing to use in a deployment.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setElbInfoList(java.util.Collection)} or {@link #withElbInfoList(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param elbInfoList
         *        An array containing information about the load balancer in Elastic Load Balancing to use in a
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elbInfoList(ELBInfo... elbInfoList);
    }

    private static final class BuilderImpl implements Builder {
        private List<ELBInfo> elbInfoList = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerInfo model) {
            setElbInfoList(model.elbInfoList);
        }

        public final Collection<ELBInfo> getElbInfoList() {
            return elbInfoList;
        }

        @Override
        public final Builder elbInfoList(Collection<ELBInfo> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copy(elbInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(ELBInfo... elbInfoList) {
            if (this.elbInfoList == null) {
                this.elbInfoList = new SdkInternalList<>(elbInfoList.length);
            }
            for (ELBInfo e : elbInfoList) {
                this.elbInfoList.add(e);
            }
            return this;
        }

        public final void setElbInfoList(Collection<ELBInfo> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copy(elbInfoList);
        }

        @SafeVarargs
        public final void setElbInfoList(ELBInfo... elbInfoList) {
            if (this.elbInfoList == null) {
                this.elbInfoList = new SdkInternalList<>(elbInfoList.length);
            }
            for (ELBInfo e : elbInfoList) {
                this.elbInfoList.add(e);
            }
        }

        @Override
        public LoadBalancerInfo build() {
            return new LoadBalancerInfo(this);
        }
    }
}
