/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of list on-premises instances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOnPremisesInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOnPremisesInstancesResponse.Builder, ListOnPremisesInstancesResponse> {
    private final List<String> instanceNames;

    private final String nextToken;

    private ListOnPremisesInstancesResponse(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of matching on-premises instance names.
     * </p>
     * 
     * @return The list of matching on-premises instance names.
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * on-premises instances call to return the next set of on-premises instances in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list on-premises instances call to return the next set of on-premises instances in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceNames() == null) ? 0 : instanceNames().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesResponse)) {
            return false;
        }
        ListOnPremisesInstancesResponse other = (ListOnPremisesInstancesResponse) obj;
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        if (other.instanceNames() != null && !other.instanceNames().equals(this.instanceNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceNames() != null) {
            sb.append("InstanceNames: ").append(instanceNames()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOnPremisesInstancesResponse> {
        /**
         * <p>
         * The list of matching on-premises instance names.
         * </p>
         * 
         * @param instanceNames
         *        The list of matching on-premises instance names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The list of matching on-premises instance names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setInstanceNames(java.util.Collection)} or {@link #withInstanceNames(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param instanceNames
         *        The list of matching on-premises instance names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list on-premises instances call to return the next set of on-premises instances in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list on-premises instances call to return the next set of on-premises instances in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instanceNames = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesResponse model) {
            setInstanceNames(model.instanceNames);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList<>(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @SafeVarargs
        public final void setInstanceNames(String... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList<>(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOnPremisesInstancesResponse build() {
            return new ListOnPremisesInstancesResponse(this);
        }
    }
}
