/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a ListOnPremisesInstances operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOnPremisesInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListOnPremisesInstancesRequest.Builder, ListOnPremisesInstancesRequest> {
    private final String registrationStatus;

    private final List<TagFilter> tagFilters;

    private final String nextToken;

    private ListOnPremisesInstancesRequest(BuilderImpl builder) {
        this.registrationStatus = builder.registrationStatus;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The registration status of the on-premises instances:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Deregistered: Include deregistered on-premises instances in the resulting list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Registered: Include registered on-premises instances in the resulting list.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The registration status of the on-premises instances:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Deregistered: Include deregistered on-premises instances in the resulting list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Registered: Include registered on-premises instances in the resulting list.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public String registrationStatus() {
        return registrationStatus;
    }

    /**
     * <p>
     * The on-premises instance tags that will be used to restrict the corresponding on-premises instance names
     * returned.
     * </p>
     * 
     * @return The on-premises instance tags that will be used to restrict the corresponding on-premises instance names
     *         returned.
     */
    public List<TagFilter> tagFilters() {
        return tagFilters;
    }

    /**
     * <p>
     * An identifier returned from the previous list on-premises instances call. It can be used to return the next set
     * of on-premises instances in the list.
     * </p>
     * 
     * @return An identifier returned from the previous list on-premises instances call. It can be used to return the
     *         next set of on-premises instances in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((registrationStatus() == null) ? 0 : registrationStatus().hashCode());
        hashCode = 31 * hashCode + ((tagFilters() == null) ? 0 : tagFilters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesRequest)) {
            return false;
        }
        ListOnPremisesInstancesRequest other = (ListOnPremisesInstancesRequest) obj;
        if (other.registrationStatus() == null ^ this.registrationStatus() == null) {
            return false;
        }
        if (other.registrationStatus() != null && !other.registrationStatus().equals(this.registrationStatus())) {
            return false;
        }
        if (other.tagFilters() == null ^ this.tagFilters() == null) {
            return false;
        }
        if (other.tagFilters() != null && !other.tagFilters().equals(this.tagFilters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (registrationStatus() != null) {
            sb.append("RegistrationStatus: ").append(registrationStatus()).append(",");
        }
        if (tagFilters() != null) {
            sb.append("TagFilters: ").append(tagFilters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOnPremisesInstancesRequest> {
        /**
         * <p>
         * The registration status of the on-premises instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Deregistered: Include deregistered on-premises instances in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Registered: Include registered on-premises instances in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationStatus
         *        The registration status of the on-premises instances:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Deregistered: Include deregistered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Registered: Include registered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(String registrationStatus);

        /**
         * <p>
         * The registration status of the on-premises instances:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Deregistered: Include deregistered on-premises instances in the resulting list.
         * </p>
         * </li>
         * <li>
         * <p>
         * Registered: Include registered on-premises instances in the resulting list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param registrationStatus
         *        The registration status of the on-premises instances:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Deregistered: Include deregistered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Registered: Include registered on-premises instances in the resulting list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatus(RegistrationStatus registrationStatus);

        /**
         * <p>
         * The on-premises instance tags that will be used to restrict the corresponding on-premises instance names
         * returned.
         * </p>
         * 
         * @param tagFilters
         *        The on-premises instance tags that will be used to restrict the corresponding on-premises instance
         *        names returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<TagFilter> tagFilters);

        /**
         * <p>
         * The on-premises instance tags that will be used to restrict the corresponding on-premises instance names
         * returned.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagFilters(java.util.Collection)} or {@link #withTagFilters(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagFilters
         *        The on-premises instance tags that will be used to restrict the corresponding on-premises instance
         *        names returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(TagFilter... tagFilters);

        /**
         * <p>
         * An identifier returned from the previous list on-premises instances call. It can be used to return the next
         * set of on-premises instances in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier returned from the previous list on-premises instances call. It can be used to return the
         *        next set of on-premises instances in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String registrationStatus;

        private List<TagFilter> tagFilters = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesRequest model) {
            setRegistrationStatus(model.registrationStatus);
            setTagFilters(model.tagFilters);
            setNextToken(model.nextToken);
        }

        public final String getRegistrationStatus() {
            return registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus.toString());
            return this;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        public final void setRegistrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus.toString());
        }

        public final Collection<TagFilter> getTagFilters() {
            return tagFilters;
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter... tagFilters) {
            if (this.tagFilters == null) {
                this.tagFilters = new SdkInternalList<>(tagFilters.length);
            }
            for (TagFilter e : tagFilters) {
                this.tagFilters.add(e);
            }
            return this;
        }

        public final void setTagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
        }

        @SafeVarargs
        public final void setTagFilters(TagFilter... tagFilters) {
            if (this.tagFilters == null) {
                this.tagFilters = new SdkInternalList<>(tagFilters.length);
            }
            for (TagFilter e : tagFilters) {
                this.tagFilters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOnPremisesInstancesRequest build() {
            return new ListOnPremisesInstancesRequest(this);
        }
    }
}
