/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListGitHubAccountTokenNames operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListGitHubAccountTokenNamesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListGitHubAccountTokenNamesResponse.Builder, ListGitHubAccountTokenNamesResponse> {
    private final List<String> tokenNameList;

    private final String nextToken;

    private ListGitHubAccountTokenNamesResponse(BuilderImpl builder) {
        this.tokenNameList = builder.tokenNameList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of names of connections to GitHub accounts.
     * </p>
     * 
     * @return A list of names of connections to GitHub accounts.
     */
    public List<String> tokenNameList() {
        return tokenNameList;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
     * ListGitHubAccountTokenNames call to return the next set of names in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent ListGitHubAccountTokenNames call to return the next set of names in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tokenNameList() == null) ? 0 : tokenNameList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGitHubAccountTokenNamesResponse)) {
            return false;
        }
        ListGitHubAccountTokenNamesResponse other = (ListGitHubAccountTokenNamesResponse) obj;
        if (other.tokenNameList() == null ^ this.tokenNameList() == null) {
            return false;
        }
        if (other.tokenNameList() != null && !other.tokenNameList().equals(this.tokenNameList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tokenNameList() != null) {
            sb.append("TokenNameList: ").append(tokenNameList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListGitHubAccountTokenNamesResponse> {
        /**
         * <p>
         * A list of names of connections to GitHub accounts.
         * </p>
         * 
         * @param tokenNameList
         *        A list of names of connections to GitHub accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenNameList(Collection<String> tokenNameList);

        /**
         * <p>
         * A list of names of connections to GitHub accounts.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTokenNameList(java.util.Collection)} or {@link #withTokenNameList(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param tokenNameList
         *        A list of names of connections to GitHub accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenNameList(String... tokenNameList);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * ListGitHubAccountTokenNames call to return the next set of names in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent ListGitHubAccountTokenNames call to return the next set of names in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> tokenNameList = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGitHubAccountTokenNamesResponse model) {
            setTokenNameList(model.tokenNameList);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getTokenNameList() {
            return tokenNameList;
        }

        @Override
        public final Builder tokenNameList(Collection<String> tokenNameList) {
            this.tokenNameList = GitHubAccountTokenNameListCopier.copy(tokenNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenNameList(String... tokenNameList) {
            if (this.tokenNameList == null) {
                this.tokenNameList = new SdkInternalList<>(tokenNameList.length);
            }
            for (String e : tokenNameList) {
                this.tokenNameList.add(e);
            }
            return this;
        }

        public final void setTokenNameList(Collection<String> tokenNameList) {
            this.tokenNameList = GitHubAccountTokenNameListCopier.copy(tokenNameList);
        }

        @SafeVarargs
        public final void setTokenNameList(String... tokenNameList) {
            if (this.tokenNameList == null) {
                this.tokenNameList = new SdkInternalList<>(tokenNameList.length);
            }
            for (String e : tokenNameList) {
                this.tokenNameList.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGitHubAccountTokenNamesResponse build() {
            return new ListGitHubAccountTokenNamesResponse(this);
        }
    }
}
