/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a ListDeployments operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeploymentsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDeploymentsResponse.Builder, ListDeploymentsResponse> {
    private final List<String> deployments;

    private final String nextToken;

    private ListDeploymentsResponse(BuilderImpl builder) {
        this.deployments = builder.deployments;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of deployment IDs.
     * </p>
     * 
     * @return A list of deployment IDs.
     */
    public List<String> deployments() {
        return deployments;
    }

    /**
     * <p>
     * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent list
     * deployments call to return the next set of deployments in the list.
     * </p>
     * 
     * @return If a large amount of information is returned, an identifier is also returned. It can be used in a
     *         subsequent list deployments call to return the next set of deployments in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deployments() == null) ? 0 : deployments().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsResponse)) {
            return false;
        }
        ListDeploymentsResponse other = (ListDeploymentsResponse) obj;
        if (other.deployments() == null ^ this.deployments() == null) {
            return false;
        }
        if (other.deployments() != null && !other.deployments().equals(this.deployments())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deployments() != null) {
            sb.append("Deployments: ").append(deployments()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDeploymentsResponse> {
        /**
         * <p>
         * A list of deployment IDs.
         * </p>
         * 
         * @param deployments
         *        A list of deployment IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Collection<String> deployments);

        /**
         * <p>
         * A list of deployment IDs.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeployments(java.util.Collection)} or {@link #withDeployments(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param deployments
         *        A list of deployment IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(String... deployments);

        /**
         * <p>
         * If a large amount of information is returned, an identifier is also returned. It can be used in a subsequent
         * list deployments call to return the next set of deployments in the list.
         * </p>
         * 
         * @param nextToken
         *        If a large amount of information is returned, an identifier is also returned. It can be used in a
         *        subsequent list deployments call to return the next set of deployments in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> deployments = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsResponse model) {
            setDeployments(model.deployments);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getDeployments() {
            return deployments;
        }

        @Override
        public final Builder deployments(Collection<String> deployments) {
            this.deployments = DeploymentsListCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(String... deployments) {
            if (this.deployments == null) {
                this.deployments = new SdkInternalList<>(deployments.length);
            }
            for (String e : deployments) {
                this.deployments.add(e);
            }
            return this;
        }

        public final void setDeployments(Collection<String> deployments) {
            this.deployments = DeploymentsListCopier.copy(deployments);
        }

        @SafeVarargs
        public final void setDeployments(String... deployments) {
            if (this.deployments == null) {
                this.deployments = new SdkInternalList<>(deployments.length);
            }
            for (String e : deployments) {
                this.deployments.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentsResponse build() {
            return new ListDeploymentsResponse(this);
        }
    }
}
